package software.amazon.awscdk.core;

/**
 * Options applied when copying directories into the staging location.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * FileCopyOptions fileCopyOptions = FileCopyOptions.builder()
 *         .exclude(List.of("exclude"))
 *         .followSymlinks(SymlinkFollowMode.NEVER)
 *         .ignoreMode(IgnoreMode.GLOB)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:31.981Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.FileCopyOptions")
@software.amazon.jsii.Jsii.Proxy(FileCopyOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileCopyOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Glob patterns to exclude from the copy.
     * <p>
     * Default: - nothing is excluded
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclude() {
        return null;
    }

    /**
     * A strategy for how to handle symlinks.
     * <p>
     * Default: SymlinkFollowMode.NEVER
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SymlinkFollowMode getFollowSymlinks() {
        return null;
    }

    /**
     * The ignore behavior to use for exclude patterns.
     * <p>
     * Default: IgnoreMode.GLOB
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IgnoreMode getIgnoreMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileCopyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileCopyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileCopyOptions> {
        java.util.List<java.lang.String> exclude;
        software.amazon.awscdk.core.SymlinkFollowMode followSymlinks;
        software.amazon.awscdk.core.IgnoreMode ignoreMode;

        /**
         * Sets the value of {@link FileCopyOptions#getExclude}
         * @param exclude Glob patterns to exclude from the copy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link FileCopyOptions#getFollowSymlinks}
         * @param followSymlinks A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(software.amazon.awscdk.core.SymlinkFollowMode followSymlinks) {
            this.followSymlinks = followSymlinks;
            return this;
        }

        /**
         * Sets the value of {@link FileCopyOptions#getIgnoreMode}
         * @param ignoreMode The ignore behavior to use for exclude patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(software.amazon.awscdk.core.IgnoreMode ignoreMode) {
            this.ignoreMode = ignoreMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileCopyOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileCopyOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FileCopyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileCopyOptions {
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.core.SymlinkFollowMode followSymlinks;
        private final software.amazon.awscdk.core.IgnoreMode ignoreMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.followSymlinks = software.amazon.jsii.Kernel.get(this, "followSymlinks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SymlinkFollowMode.class));
            this.ignoreMode = software.amazon.jsii.Kernel.get(this, "ignoreMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IgnoreMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.exclude = builder.exclude;
            this.followSymlinks = builder.followSymlinks;
            this.ignoreMode = builder.ignoreMode;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final software.amazon.awscdk.core.SymlinkFollowMode getFollowSymlinks() {
            return this.followSymlinks;
        }

        @Override
        public final software.amazon.awscdk.core.IgnoreMode getIgnoreMode() {
            return this.ignoreMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollowSymlinks() != null) {
                data.set("followSymlinks", om.valueToTree(this.getFollowSymlinks()));
            }
            if (this.getIgnoreMode() != null) {
                data.set("ignoreMode", om.valueToTree(this.getIgnoreMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.FileCopyOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileCopyOptions.Jsii$Proxy that = (FileCopyOptions.Jsii$Proxy) o;

            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.followSymlinks != null ? !this.followSymlinks.equals(that.followSymlinks) : that.followSymlinks != null) return false;
            return this.ignoreMode != null ? this.ignoreMode.equals(that.ignoreMode) : that.ignoreMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.exclude != null ? this.exclude.hashCode() : 0;
            result = 31 * result + (this.followSymlinks != null ? this.followSymlinks.hashCode() : 0);
            result = 31 * result + (this.ignoreMode != null ? this.ignoreMode.hashCode() : 0);
            return result;
        }
    }
}
