package software.amazon.awscdk.core;

/**
 * The Rules that define template constraints in an AWS Service Catalog portfolio describe when end users can use the template and which values they can specify for parameters that are declared in the AWS CloudFormation template used to create the product they are attempting to use.
 * <p>
 * Rules
 * are useful for preventing end users from inadvertently specifying an incorrect value.
 * For example, you can add a rule to verify whether end users specified a valid subnet in a
 * given VPC or used m1.small instance types for test environments. AWS CloudFormation uses
 * rules to validate parameter values before it creates the resources for the product.
 * <p>
 * A rule can include a RuleCondition property and must include an Assertions property.
 * For each rule, you can define only one rule condition; you can define one or more asserts within the Assertions property.
 * You define a rule condition and assertions by using rule-specific intrinsic functions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnInclude cfnTemplate;
 * // mutating the rule
 * CfnParameter myParameter;
 * CfnRule rule = cfnTemplate.getRule("MyRule");
 * rule.addAssertion(Fn.conditionContains(List.of("m1.small"), myParameter.getValueAsString()), "MyParameter has to be m1.small");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:31.877Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnRule")
public class CfnRule extends software.amazon.awscdk.core.CfnRefElement {

    protected CfnRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates and adds a rule.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id This parameter is required.
     * @param props The rule props.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Creates and adds a rule.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds an assertion to the rule.
     * <p>
     * @param condition The expression to evaluation. This parameter is required.
     * @param description The description of the assertion. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAssertion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ICfnConditionExpression condition, final @org.jetbrains.annotations.NotNull java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "addAssertion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(condition, "condition is required"), java.util.Objects.requireNonNull(description, "description is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.CfnRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.CfnRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope The parent construct. This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.core.CfnRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Assertions which define the rule.
         * <p>
         * Default: - No assertions for the rule.
         * <p>
         * @return {@code this}
         * @param assertions Assertions which define the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assertions(final java.util.List<? extends software.amazon.awscdk.core.CfnRuleAssertion> assertions) {
            this.props().assertions(assertions);
            return this;
        }

        /**
         * If the rule condition evaluates to false, the rule doesn't take effect.
         * <p>
         * If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
         * <p>
         * Default: - Rule's assertions will always take effect.
         * <p>
         * @return {@code this}
         * @param ruleCondition If the rule condition evaluates to false, the rule doesn't take effect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleCondition(final software.amazon.awscdk.core.ICfnConditionExpression ruleCondition) {
            this.props().ruleCondition(ruleCondition);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.CfnRule build() {
            return new software.amazon.awscdk.core.CfnRule(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.CfnRuleProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.CfnRuleProps.Builder();
            }
            return this.props;
        }
    }
}
