/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnElement;
import software.amazon.awscdk.core.CfnParameterProps;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.IResolveContext;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/core.CfnParameter")
public class CfnParameter
extends CfnElement {
    protected CfnParameter(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnParameter(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnParameter(@NotNull Construct scope, @NotNull String id, @Nullable CfnParameterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnParameter(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public Object resolve(@NotNull IResolveContext _context) {
        return Kernel.call((Object)this, (String)"resolve", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[]{Objects.requireNonNull(_context, "_context is required")});
    }

    @NotNull
    public IResolvable getValue() {
        return (IResolvable)Kernel.get((Object)this, (String)"value", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public List<String> getValueAsList() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"valueAsList", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Number getValueAsNumber() {
        return (Number)Kernel.get((Object)this, (String)"valueAsNumber", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public String getValueAsString() {
        return (String)Kernel.get((Object)this, (String)"valueAsString", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Object getDefaultValue() {
        return Kernel.get((Object)this, (String)"default", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefaultValue(@NotNull Object value) {
        Kernel.set((Object)this, (String)"default", (Object)Objects.requireNonNull(value, "default is required"));
    }

    @NotNull
    public Boolean getNoEcho() {
        return (Boolean)Kernel.get((Object)this, (String)"noEcho", (NativeType)NativeType.forClass(Boolean.class));
    }

    public void setNoEcho(@NotNull Boolean value) {
        Kernel.set((Object)this, (String)"noEcho", (Object)Objects.requireNonNull(value, "noEcho is required"));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public String getAllowedPattern() {
        return (String)Kernel.get((Object)this, (String)"allowedPattern", (NativeType)NativeType.forClass(String.class));
    }

    public void setAllowedPattern(@Nullable String value) {
        Kernel.set((Object)this, (String)"allowedPattern", (Object)value);
    }

    @Nullable
    public List<String> getAllowedValues() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"allowedValues", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAllowedValues(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"allowedValues", value);
    }

    @Nullable
    public String getConstraintDescription() {
        return (String)Kernel.get((Object)this, (String)"constraintDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setConstraintDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"constraintDescription", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Number getMaxLength() {
        return (Number)Kernel.get((Object)this, (String)"maxLength", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxLength(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxLength", (Object)value);
    }

    @Nullable
    public Number getMaxValue() {
        return (Number)Kernel.get((Object)this, (String)"maxValue", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxValue(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxValue", (Object)value);
    }

    @Nullable
    public Number getMinLength() {
        return (Number)Kernel.get((Object)this, (String)"minLength", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMinLength(@Nullable Number value) {
        Kernel.set((Object)this, (String)"minLength", (Object)value);
    }

    @Nullable
    public Number getMinValue() {
        return (Number)Kernel.get((Object)this, (String)"minValue", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMinValue(@Nullable Number value) {
        Kernel.set((Object)this, (String)"minValue", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnParameter> {
        private final Construct scope;
        private final String id;
        private CfnParameterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder allowedPattern(String allowedPattern) {
            this.props().allowedPattern(allowedPattern);
            return this;
        }

        public Builder allowedValues(List<String> allowedValues) {
            this.props().allowedValues(allowedValues);
            return this;
        }

        public Builder constraintDescription(String constraintDescription) {
            this.props().constraintDescription(constraintDescription);
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.props().defaultValue(defaultValue);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder maxLength(Number maxLength) {
            this.props().maxLength(maxLength);
            return this;
        }

        public Builder maxValue(Number maxValue) {
            this.props().maxValue(maxValue);
            return this;
        }

        public Builder minLength(Number minLength) {
            this.props().minLength(minLength);
            return this;
        }

        public Builder minValue(Number minValue) {
            this.props().minValue(minValue);
            return this;
        }

        public Builder noEcho(Boolean noEcho) {
            this.props().noEcho(noEcho);
            return this;
        }

        public Builder type(String type) {
            this.props().type(type);
            return this;
        }

        public CfnParameter build() {
            return new CfnParameter(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnParameterProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnParameterProps.Builder();
            }
            return this.props;
        }
    }
}

