package software.amazon.awscdk.core;

/**
 * An enum-like class that represents the result of comparing two Tokens.
 * <p>
 * The return type of {&#64;link Token.compareStrings}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * TokenComparison tokenComparison = TokenComparison.BOTH_UNRESOLVED;
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:23.046Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.TokenComparison")
public class TokenComparison extends software.amazon.jsii.JsiiObject {

    protected TokenComparison(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TokenComparison(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        BOTH_UNRESOLVED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.TokenComparison.class, "BOTH_UNRESOLVED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TokenComparison.class));
        DIFFERENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.TokenComparison.class, "DIFFERENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TokenComparison.class));
        ONE_UNRESOLVED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.TokenComparison.class, "ONE_UNRESOLVED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TokenComparison.class));
        SAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.TokenComparison.class, "SAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TokenComparison.class));
    }

    /**
     * This means both components are Tokens.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.core.TokenComparison BOTH_UNRESOLVED;

    /**
     * This means we're certain the two components are NOT Tokens, and different.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.core.TokenComparison DIFFERENT;

    /**
     * This means exactly one of the components is a Token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.core.TokenComparison ONE_UNRESOLVED;

    /**
     * This means we're certain the two components are NOT Tokens, and identical.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.core.TokenComparison SAME;
}
