package software.amazon.awscdk.core;

/**
 * The lambda runtime to use for the resource provider.
 * <p>
 * This also indicates
 * which language is used for the handler.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String serviceToken = CustomResourceProvider.getOrCreate(this, "Custom::MyCustomResourceType", CustomResourceProviderProps.builder()
 *         .codeDirectory(String.format("%s/my-handler", __dirname))
 *         .runtime(CustomResourceProviderRuntime.NODEJS_12_X)
 *         .description("Lambda function created by the custom resource provider")
 *         .build());
 * CustomResource.Builder.create(this, "MyResource")
 *         .resourceType("Custom::MyCustomResourceType")
 *         .serviceToken(serviceToken)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:22.929Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CustomResourceProviderRuntime")
public enum CustomResourceProviderRuntime {
    /**
     * (deprecated) Node.js 12.x.
     * <p>
     * @deprecated Use {@link NODEJS_14_X}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    NODEJS_12,
    /**
     * Node.js 12.x.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODEJS_12_X,
    /**
     * Node.js 14.x.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODEJS_14_X,
}
