package software.amazon.awscdk.core;

/**
 * Properties to provide a Lambda-backed custom resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String serviceToken = CustomResourceProvider.getOrCreate(this, "Custom::MyCustomResourceType", CustomResourceProviderProps.builder()
 *         .codeDirectory(String.format("%s/my-handler", __dirname))
 *         .runtime(CustomResourceProviderRuntime.NODEJS_12_X)
 *         .description("Lambda function created by the custom resource provider")
 *         .build());
 * CustomResource.Builder.create(this, "MyResource")
 *         .resourceType("Custom::MyCustomResourceType")
 *         .serviceToken(serviceToken)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:22.922Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CustomResourceProps")
@software.amazon.jsii.Jsii.Proxy(CustomResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the provider which implements this custom resource type.
     * <p>
     * You can implement a provider by listening to raw AWS CloudFormation events
     * and specify the ARN of an SNS topic (<code>topic.topicArn</code>) or the ARN of an AWS
     * Lambda function (<code>lambda.functionArn</code>) or use the CDK's custom <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/custom-resources-readme.html">resource
     * provider framework</a> which makes it easier to implement robust providers.
     * <p>
     * Provider framework:
     * <p>
     * <blockquote><pre>
     * // use the provider framework from aws-cdk/custom-resources:
     * Provider provider = Provider.Builder.create(this, "ResourceProvider")
     *         .onEventHandler(onEventHandler)
     *         .isCompleteHandler(isCompleteHandler)
     *         .build();
     * CustomResource.Builder.create(this, "MyResource")
     *         .serviceToken(provider.getServiceToken())
     *         .build();
     * </pre></blockquote>
     * <p>
     * AWS Lambda function:
     * <p>
     * <blockquote><pre>
     * // invoke an AWS Lambda function when a lifecycle event occurs:
     * // invoke an AWS Lambda function when a lifecycle event occurs:
     * CustomResource.Builder.create(this, "MyResource")
     *         .serviceToken(myFunction.getFunctionArn())
     *         .build();
     * </pre></blockquote>
     * <p>
     * SNS topic:
     * <p>
     * <blockquote><pre>
     * // publish lifecycle events to an SNS topic:
     * // publish lifecycle events to an SNS topic:
     * CustomResource.Builder.create(this, "MyResource")
     *         .serviceToken(myTopic.getTopicArn())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceToken();

    /**
     * Convert all property keys to pascal case.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPascalCaseProperties() {
        return null;
    }

    /**
     * Properties to pass to the Lambda.
     * <p>
     * Default: - No properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getProperties() {
        return null;
    }

    /**
     * The policy to apply when this resource is removed from the application.
     * <p>
     * Default: cdk.RemovalPolicy.Destroy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * For custom resources, you can specify AWS::CloudFormation::CustomResource (the default) as the resource type, or you can specify your own resource type name.
     * <p>
     * For example, you can use "Custom::MyCustomResourceTypeName".
     * <p>
     * Custom resource type names must begin with "Custom::" and can include
     * alphanumeric characters and the following characters: _&#64;-. You can specify
     * a custom resource type name up to a maximum length of 60 characters. You
     * cannot change the type during an update.
     * <p>
     * Using your own resource type names helps you quickly differentiate the
     * types of custom resources in your stack. For example, if you had two custom
     * resources that conduct two different ping tests, you could name their type
     * as Custom::PingTester to make them easily identifiable as ping testers
     * (instead of using AWS::CloudFormation::CustomResource).
     * <p>
     * Default: - AWS::CloudFormation::CustomResource
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#aws-cfn-resource-type-name">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#aws-cfn-resource-type-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomResourceProps> {
        java.lang.String serviceToken;
        java.lang.Boolean pascalCaseProperties;
        java.util.Map<java.lang.String, java.lang.Object> properties;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        java.lang.String resourceType;

        /**
         * Sets the value of {@link CustomResourceProps#getServiceToken}
         * @param serviceToken The ARN of the provider which implements this custom resource type. This parameter is required.
         *                     You can implement a provider by listening to raw AWS CloudFormation events
         *                     and specify the ARN of an SNS topic (<code>topic.topicArn</code>) or the ARN of an AWS
         *                     Lambda function (<code>lambda.functionArn</code>) or use the CDK's custom <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/custom-resources-readme.html">resource
         *                     provider framework</a> which makes it easier to implement robust providers.
         *                     <p>
         *                     Provider framework:
         *                     <p>
         *                     <blockquote><pre>
         *                     // use the provider framework from aws-cdk/custom-resources:
         *                     Provider provider = Provider.Builder.create(this, "ResourceProvider")
         *                             .onEventHandler(onEventHandler)
         *                             .isCompleteHandler(isCompleteHandler)
         *                             .build();
         *                     
         *                     CustomResource.Builder.create(this, "MyResource")
         *                             .serviceToken(provider.getServiceToken())
         *                             .build();
         *                     </pre></blockquote>
         *                     <p>
         *                     AWS Lambda function:
         *                     <p>
         *                     <blockquote><pre>
         *                     // invoke an AWS Lambda function when a lifecycle event occurs:
         *                     // invoke an AWS Lambda function when a lifecycle event occurs:
         *                     CustomResource.Builder.create(this, "MyResource")
         *                             .serviceToken(myFunction.getFunctionArn())
         *                             .build();
         *                     </pre></blockquote>
         *                     <p>
         *                     SNS topic:
         *                     <p>
         *                     <blockquote><pre>
         *                     // publish lifecycle events to an SNS topic:
         *                     // publish lifecycle events to an SNS topic:
         *                     CustomResource.Builder.create(this, "MyResource")
         *                             .serviceToken(myTopic.getTopicArn())
         *                             .build();
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceToken(java.lang.String serviceToken) {
            this.serviceToken = serviceToken;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProps#getPascalCaseProperties}
         * @param pascalCaseProperties Convert all property keys to pascal case.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pascalCaseProperties(java.lang.Boolean pascalCaseProperties) {
            this.pascalCaseProperties = pascalCaseProperties;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProps#getProperties}
         * @param properties Properties to pass to the Lambda.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder properties(java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
            this.properties = (java.util.Map<java.lang.String, java.lang.Object>)properties;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProps#getRemovalPolicy}
         * @param removalPolicy The policy to apply when this resource is removed from the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProps#getResourceType}
         * @param resourceType For custom resources, you can specify AWS::CloudFormation::CustomResource (the default) as the resource type, or you can specify your own resource type name.
         *                     For example, you can use "Custom::MyCustomResourceTypeName".
         *                     <p>
         *                     Custom resource type names must begin with "Custom::" and can include
         *                     alphanumeric characters and the following characters: _&#64;-. You can specify
         *                     a custom resource type name up to a maximum length of 60 characters. You
         *                     cannot change the type during an update.
         *                     <p>
         *                     Using your own resource type names helps you quickly differentiate the
         *                     types of custom resources in your stack. For example, if you had two custom
         *                     resources that conduct two different ping tests, you could name their type
         *                     as Custom::PingTester to make them easily identifiable as ping testers
         *                     (instead of using AWS::CloudFormation::CustomResource).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomResourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomResourceProps {
        private final java.lang.String serviceToken;
        private final java.lang.Boolean pascalCaseProperties;
        private final java.util.Map<java.lang.String, java.lang.Object> properties;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.lang.String resourceType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceToken = software.amazon.jsii.Kernel.get(this, "serviceToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pascalCaseProperties = software.amazon.jsii.Kernel.get(this, "pascalCaseProperties", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceToken = java.util.Objects.requireNonNull(builder.serviceToken, "serviceToken is required");
            this.pascalCaseProperties = builder.pascalCaseProperties;
            this.properties = (java.util.Map<java.lang.String, java.lang.Object>)builder.properties;
            this.removalPolicy = builder.removalPolicy;
            this.resourceType = builder.resourceType;
        }

        @Override
        public final java.lang.String getServiceToken() {
            return this.serviceToken;
        }

        @Override
        public final java.lang.Boolean getPascalCaseProperties() {
            return this.pascalCaseProperties;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getProperties() {
            return this.properties;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceToken", om.valueToTree(this.getServiceToken()));
            if (this.getPascalCaseProperties() != null) {
                data.set("pascalCaseProperties", om.valueToTree(this.getPascalCaseProperties()));
            }
            if (this.getProperties() != null) {
                data.set("properties", om.valueToTree(this.getProperties()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getResourceType() != null) {
                data.set("resourceType", om.valueToTree(this.getResourceType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CustomResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomResourceProps.Jsii$Proxy that = (CustomResourceProps.Jsii$Proxy) o;

            if (!serviceToken.equals(that.serviceToken)) return false;
            if (this.pascalCaseProperties != null ? !this.pascalCaseProperties.equals(that.pascalCaseProperties) : that.pascalCaseProperties != null) return false;
            if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.resourceType != null ? this.resourceType.equals(that.resourceType) : that.resourceType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.serviceToken.hashCode();
            result = 31 * result + (this.pascalCaseProperties != null ? this.pascalCaseProperties.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
            return result;
        }
    }
}
