package software.amazon.awscdk.core;

/**
 * Represents a CloudFormation mapping.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnMapping regionTable = CfnMapping.Builder.create(this, "RegionTable")
 *         .mapping(Map.of(
 *                 "us-east-1", Map.of(
 *                         "regionName", "US East (N. Virginia)"),
 *                 "us-east-2", Map.of(
 *                         "regionName", "US East (Ohio)")))
 *         .build();
 * regionTable.findInMap(Aws.REGION, "regionName");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:22.821Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnMapping")
public class CfnMapping extends software.amazon.awscdk.core.CfnRefElement {

    protected CfnMapping(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMapping(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMapping(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnMappingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMapping(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @return A reference to a value in the map based on the two keys.
     * @param key1 This parameter is required.
     * @param key2 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String findInMap(final @org.jetbrains.annotations.NotNull java.lang.String key1, final @org.jetbrains.annotations.NotNull java.lang.String key2) {
        return software.amazon.jsii.Kernel.call(this, "findInMap", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(key1, "key1 is required"), java.util.Objects.requireNonNull(key2, "key2 is required") });
    }

    /**
     * Sets a value in the map based on the two keys.
     * <p>
     * @param key1 This parameter is required.
     * @param key2 This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValue(final @org.jetbrains.annotations.NotNull java.lang.String key1, final @org.jetbrains.annotations.NotNull java.lang.String key2, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.call(this, "setValue", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key1, "key1 is required"), java.util.Objects.requireNonNull(key2, "key2 is required"), value });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.CfnMapping}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.CfnMapping> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.core.CfnMappingProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * @return {@code this}
         * @param lazy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lazy(final java.lang.Boolean lazy) {
            this.props().lazy(lazy);
            return this;
        }

        /**
         * Mapping of key to a set of corresponding set of named values.
         * <p>
         * The key identifies a map of name-value pairs and must be unique within the mapping.
         * <p>
         * For example, if you want to set values based on a region, you can create a mapping
         * that uses the region name as a key and contains the values you want to specify for
         * each specific region.
         * <p>
         * Default: - No mapping.
         * <p>
         * @return {@code this}
         * @param mapping Mapping of key to a set of corresponding set of named values. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapping(final java.util.Map<java.lang.String, ? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> mapping) {
            this.props().mapping(mapping);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnMapping}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.CfnMapping build() {
            return new software.amazon.awscdk.core.CfnMapping(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.CfnMappingProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.CfnMappingProps.Builder();
            }
            return this.props;
        }
    }
}
