package software.amazon.awscdk.core;

/**
 * A construct which represents an entire CDK app. This construct is normally the root of the construct tree.
 * 
 * You would normally define an `App` instance in your program's entrypoint,
 * then define constructs where the app is used as the parent scope.
 * 
 * After all the child constructs are defined within the app, you should call
 * `app.synth()` which will emit a "cloud assembly" from this app into the
 * directory specified by `outdir`. Cloud assemblies includes artifacts such as
 * CloudFormation templates and assets that are needed to deploy this app into
 * the AWS cloud.
 * 
 * @see https://docs.aws.amazon.com/cdk/latest/guide/apps_and_stacks.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.2 (build faba0be)", date = "2019-11-11T17:17:47.115Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.App")
public class App extends software.amazon.awscdk.core.Construct {

    protected App(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected App(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Initializes a CDK application.
     * 
     * @param props initialization properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public App(final software.amazon.awscdk.core.AppProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     * Initializes a CDK application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public App() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Checks if an object is an instance of the `App` class.
     * 
     * @return `true` if `obj` is an `App`.
     * @param obj The object to evaluate. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.Boolean isApp(final java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.App.class, "isApp", java.lang.Boolean.class, new Object[] { obj });
    }

    /**
     * Synthesizes a cloud assembly for this app.
     * 
     * Emits it to the directory
     * specified by `outdir`.
     * 
     * @return a `CloudAssembly` which can be used to inspect synthesized
     * artifacts such as CloudFormation templates and assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.cxapi.CloudAssembly synth() {
        return this.jsiiCall("synth", software.amazon.awscdk.cxapi.CloudAssembly.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.App}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.core.AppProps.Builder props;

        private Builder() {
        }

        /**
         * @return {@code this}
         * @param autoSynth Automatically call `synth()` before the program exits. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoSynth(final java.lang.Boolean autoSynth) {
            this.props().autoSynth(autoSynth);
            return this;
        }

        /**
         * @return {@code this}
         * @param context Additional context values for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder context(final java.util.Map<java.lang.String, java.lang.String> context) {
            this.props().context(context);
            return this;
        }

        /**
         * @return {@code this}
         * @param outdir The output directory into which to emit synthesized artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outdir(final java.lang.String outdir) {
            this.props().outdir(outdir);
            return this;
        }

        /**
         * @return {@code this}
         * @param runtimeInfo Include runtime versioning information in cloud assembly manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeInfo(final java.lang.Boolean runtimeInfo) {
            this.props().runtimeInfo(runtimeInfo);
            return this;
        }

        /**
         * @return {@code this}
         * @param stackTraces Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackTraces(final java.lang.Boolean stackTraces) {
            this.props().stackTraces(stackTraces);
            return this;
        }

        /**
         * @return {@code this}
         * @param treeMetadata Include construct tree metadata as part of the Cloud Assembly. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treeMetadata(final java.lang.Boolean treeMetadata) {
            this.props().treeMetadata(treeMetadata);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.App}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.App build() {
            return new software.amazon.awscdk.core.App(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.AppProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.AppProps.Builder();
            }
            return this.props;
        }
    }
}
