package software.amazon.awscdk.core;

/**
 * Options for synthesis.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:12:45.320Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SynthesisOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cxapi.AssemblyBuildOptions {

    /**
     * The output directory into which to synthesize the cloud assembly.
     * 
     * Default: - creates a temporary directory
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getOutdir();

    /**
     * Whether synthesis should skip the validation phase.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getSkipValidation();

    /**
     * @return a {@link Builder} of {@link SynthesisOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SynthesisOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String outdir;
        private java.lang.Boolean skipValidation;
        private software.amazon.awscdk.cxapi.RuntimeInfo runtimeInfo;

        /**
         * Sets the value of Outdir
         * @param outdir The output directory into which to synthesize the cloud assembly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outdir(java.lang.String outdir) {
            this.outdir = outdir;
            return this;
        }

        /**
         * Sets the value of SkipValidation
         * @param skipValidation Whether synthesis should skip the validation phase.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipValidation(java.lang.Boolean skipValidation) {
            this.skipValidation = skipValidation;
            return this;
        }

        /**
         * Sets the value of RuntimeInfo
         * @param runtimeInfo Include the specified runtime information (module versions) in manifest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtimeInfo(software.amazon.awscdk.cxapi.RuntimeInfo runtimeInfo) {
            this.runtimeInfo = runtimeInfo;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SynthesisOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public SynthesisOptions build() {
            return new Jsii$Proxy(outdir, skipValidation, runtimeInfo);
        }
    }

    /**
     * An implementation for {@link SynthesisOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SynthesisOptions {
        private final java.lang.String outdir;
        private final java.lang.Boolean skipValidation;
        private final software.amazon.awscdk.cxapi.RuntimeInfo runtimeInfo;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.outdir = this.jsiiGet("outdir", java.lang.String.class);
            this.skipValidation = this.jsiiGet("skipValidation", java.lang.Boolean.class);
            this.runtimeInfo = this.jsiiGet("runtimeInfo", software.amazon.awscdk.cxapi.RuntimeInfo.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String outdir, java.lang.Boolean skipValidation, software.amazon.awscdk.cxapi.RuntimeInfo runtimeInfo) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.outdir = outdir;
            this.skipValidation = skipValidation;
            this.runtimeInfo = runtimeInfo;
        }

        @Override
        public java.lang.String getOutdir() {
            return this.outdir;
        }

        @Override
        public java.lang.Boolean getSkipValidation() {
            return this.skipValidation;
        }

        @Override
        public software.amazon.awscdk.cxapi.RuntimeInfo getRuntimeInfo() {
            return this.runtimeInfo;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getOutdir() != null) {
                obj.set("outdir", om.valueToTree(this.getOutdir()));
            }
            if (this.getSkipValidation() != null) {
                obj.set("skipValidation", om.valueToTree(this.getSkipValidation()));
            }
            if (this.getRuntimeInfo() != null) {
                obj.set("runtimeInfo", om.valueToTree(this.getRuntimeInfo()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SynthesisOptions.Jsii$Proxy that = (SynthesisOptions.Jsii$Proxy) o;

            if (this.outdir != null ? !this.outdir.equals(that.outdir) : that.outdir != null) return false;
            if (this.skipValidation != null ? !this.skipValidation.equals(that.skipValidation) : that.skipValidation != null) return false;
            return this.runtimeInfo != null ? this.runtimeInfo.equals(that.runtimeInfo) : that.runtimeInfo == null;
        }

        @Override
        public int hashCode() {
            int result = this.outdir != null ? this.outdir.hashCode() : 0;
            result = 31 * result + (this.skipValidation != null ? this.skipValidation.hashCode() : 0);
            result = 31 * result + (this.runtimeInfo != null ? this.runtimeInfo.hashCode() : 0);
            return result;
        }
    }
}
