package software.amazon.awscdk.core;

/**
 * The location of the published file asset.
 * 
 * This is where the asset
 * can be consumed at runtime.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:12:45.305Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileAssetLocation extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBucketName();

    /**
     * The Amazon S3 object key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getObjectKey();

    /**
     * The HTTP URL of this asset on Amazon S3.
     * 
     * Example:
     * 
     * https://s3-us-east-1.amazonaws.com/mybucket/myobject
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getS3Url();

    /**
     * @return a {@link Builder} of {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String bucketName;
        private java.lang.String objectKey;
        private java.lang.String s3Url;

        /**
         * Sets the value of BucketName
         * @param bucketName The name of the Amazon S3 bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of ObjectKey
         * @param objectKey The Amazon S3 object key. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectKey(java.lang.String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        /**
         * Sets the value of S3Url
         * @param s3Url The HTTP URL of this asset on Amazon S3. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Url(java.lang.String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileAssetLocation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public FileAssetLocation build() {
            return new Jsii$Proxy(bucketName, objectKey, s3Url);
        }
    }

    /**
     * An implementation for {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileAssetLocation {
        private final java.lang.String bucketName;
        private final java.lang.String objectKey;
        private final java.lang.String s3Url;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.bucketName = this.jsiiGet("bucketName", java.lang.String.class);
            this.objectKey = this.jsiiGet("objectKey", java.lang.String.class);
            this.s3Url = this.jsiiGet("s3Url", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String bucketName, java.lang.String objectKey, java.lang.String s3Url) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketName = java.util.Objects.requireNonNull(bucketName, "bucketName is required");
            this.objectKey = java.util.Objects.requireNonNull(objectKey, "objectKey is required");
            this.s3Url = java.util.Objects.requireNonNull(s3Url, "s3Url is required");
        }

        @Override
        public java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public java.lang.String getObjectKey() {
            return this.objectKey;
        }

        @Override
        public java.lang.String getS3Url() {
            return this.s3Url;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("bucketName", om.valueToTree(this.getBucketName()));
            obj.set("objectKey", om.valueToTree(this.getObjectKey()));
            obj.set("s3Url", om.valueToTree(this.getS3Url()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileAssetLocation.Jsii$Proxy that = (FileAssetLocation.Jsii$Proxy) o;

            if (!bucketName.equals(that.bucketName)) return false;
            if (!objectKey.equals(that.objectKey)) return false;
            return this.s3Url.equals(that.s3Url);
        }

        @Override
        public int hashCode() {
            int result = this.bucketName.hashCode();
            result = 31 * result + (this.objectKey.hashCode());
            result = 31 * result + (this.s3Url.hashCode());
            return result;
        }
    }
}
