package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:12:45.304Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DockerImageAssetSource extends software.amazon.jsii.JsiiSerializable {

    /**
     * The directory where the Dockerfile is stored, must be relative to the cloud assembly root.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDirectoryName();

    /**
     * The hash of the contents of the docker build context.
     * 
     * This hash is used
     * throughout the system to identify this image and avoid duplicate work
     * in case the source did not change.
     * 
     * NOTE: this means that if you wish to update your docker image, you
     * must make a modification to the source (e.g. add some metadata to your Dockerfile).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSourceHash();

    /**
     * Build args to pass to the `docker build` command.
     * 
     * Since Docker build arguments are resolved before deployment, keys and
     * values cannot refer to unresolved tokens (such as `lambda.functionArn` or
     * `queue.queueUrl`).
     * 
     * Default: - no build args are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.String> getDockerBuildArgs();

    /**
     * Docker target to build to.
     * 
     * Default: - no target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDockerBuildTarget();

    /**
     * ECR repository name.
     * 
     * Specify this property if you need to statically address the image, e.g.
     * from a Kubernetes Pod. Note, this is only the repository name, without the
     * registry and the tag parts.
     * 
     * Default: - automatically derived from the asset's ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getRepositoryName();

    /**
     * @return a {@link Builder} of {@link DockerImageAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerImageAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String directoryName;
        private java.lang.String sourceHash;
        private java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs;
        private java.lang.String dockerBuildTarget;
        private java.lang.String repositoryName;

        /**
         * Sets the value of DirectoryName
         * @param directoryName The directory where the Dockerfile is stored, must be relative to the cloud assembly root. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directoryName(java.lang.String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        /**
         * Sets the value of SourceHash
         * @param sourceHash The hash of the contents of the docker build context. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceHash(java.lang.String sourceHash) {
            this.sourceHash = sourceHash;
            return this;
        }

        /**
         * Sets the value of DockerBuildArgs
         * @param dockerBuildArgs Build args to pass to the `docker build` command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerBuildArgs(java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs) {
            this.dockerBuildArgs = dockerBuildArgs;
            return this;
        }

        /**
         * Sets the value of DockerBuildTarget
         * @param dockerBuildTarget Docker target to build to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerBuildTarget(java.lang.String dockerBuildTarget) {
            this.dockerBuildTarget = dockerBuildTarget;
            return this;
        }

        /**
         * Sets the value of RepositoryName
         * @param repositoryName ECR repository name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageAssetSource}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public DockerImageAssetSource build() {
            return new Jsii$Proxy(directoryName, sourceHash, dockerBuildArgs, dockerBuildTarget, repositoryName);
        }
    }

    /**
     * An implementation for {@link DockerImageAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerImageAssetSource {
        private final java.lang.String directoryName;
        private final java.lang.String sourceHash;
        private final java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs;
        private final java.lang.String dockerBuildTarget;
        private final java.lang.String repositoryName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.directoryName = this.jsiiGet("directoryName", java.lang.String.class);
            this.sourceHash = this.jsiiGet("sourceHash", java.lang.String.class);
            this.dockerBuildArgs = this.jsiiGet("dockerBuildArgs", java.util.Map.class);
            this.dockerBuildTarget = this.jsiiGet("dockerBuildTarget", java.lang.String.class);
            this.repositoryName = this.jsiiGet("repositoryName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String directoryName, java.lang.String sourceHash, java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs, java.lang.String dockerBuildTarget, java.lang.String repositoryName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.directoryName = java.util.Objects.requireNonNull(directoryName, "directoryName is required");
            this.sourceHash = java.util.Objects.requireNonNull(sourceHash, "sourceHash is required");
            this.dockerBuildArgs = dockerBuildArgs;
            this.dockerBuildTarget = dockerBuildTarget;
            this.repositoryName = repositoryName;
        }

        @Override
        public java.lang.String getDirectoryName() {
            return this.directoryName;
        }

        @Override
        public java.lang.String getSourceHash() {
            return this.sourceHash;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getDockerBuildArgs() {
            return this.dockerBuildArgs;
        }

        @Override
        public java.lang.String getDockerBuildTarget() {
            return this.dockerBuildTarget;
        }

        @Override
        public java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("directoryName", om.valueToTree(this.getDirectoryName()));
            obj.set("sourceHash", om.valueToTree(this.getSourceHash()));
            if (this.getDockerBuildArgs() != null) {
                obj.set("dockerBuildArgs", om.valueToTree(this.getDockerBuildArgs()));
            }
            if (this.getDockerBuildTarget() != null) {
                obj.set("dockerBuildTarget", om.valueToTree(this.getDockerBuildTarget()));
            }
            if (this.getRepositoryName() != null) {
                obj.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerImageAssetSource.Jsii$Proxy that = (DockerImageAssetSource.Jsii$Proxy) o;

            if (!directoryName.equals(that.directoryName)) return false;
            if (!sourceHash.equals(that.sourceHash)) return false;
            if (this.dockerBuildArgs != null ? !this.dockerBuildArgs.equals(that.dockerBuildArgs) : that.dockerBuildArgs != null) return false;
            if (this.dockerBuildTarget != null ? !this.dockerBuildTarget.equals(that.dockerBuildTarget) : that.dockerBuildTarget != null) return false;
            return this.repositoryName != null ? this.repositoryName.equals(that.repositoryName) : that.repositoryName == null;
        }

        @Override
        public int hashCode() {
            int result = this.directoryName.hashCode();
            result = 31 * result + (this.sourceHash.hashCode());
            result = 31 * result + (this.dockerBuildArgs != null ? this.dockerBuildArgs.hashCode() : 0);
            result = 31 * result + (this.dockerBuildTarget != null ? this.dockerBuildTarget.hashCode() : 0);
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            return result;
        }
    }
}
