package software.amazon.awscdk.core;

/**
 * Properties for a tag.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:13:28.345Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TagProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the tag should be applied to instances in an AutoScalingGroup.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getApplyToLaunchedInstances();

    /**
     * An array of Resource Types that will not receive this tag.
     * 
     * An empty array will allow this tag to be applied to all resources. A
     * non-empty array will apply this tag only if the Resource type is not in
     * this array.
     * 
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getExcludeResourceTypes();

    /**
     * An array of Resource Types that will receive this tag.
     * 
     * An empty array will match any Resource. A non-empty array will apply this
     * tag only to Resource types that are included in this array.
     * 
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getIncludeResourceTypes();

    /**
     * Priority of the tag operation.
     * 
     * Higher or equal priority tags will take precedence.
     * 
     * Setting priority will enable the user to control tags when they need to not
     * follow the default precedence pattern of last applied and closest to the
     * construct in the tree.
     * 
     * Default: Default priorities:
     * 
     * - 100 for {@link SetTag}
     * - 200 for {@link RemoveTag}
     * - 50 for tags added directly to CloudFormation resources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPriority();

    /**
     * @return a {@link Builder} of {@link TagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Boolean applyToLaunchedInstances;
        private java.util.List<java.lang.String> excludeResourceTypes;
        private java.util.List<java.lang.String> includeResourceTypes;
        private java.lang.Number priority;

        /**
         * Sets the value of ApplyToLaunchedInstances
         * @param applyToLaunchedInstances Whether the tag should be applied to instances in an AutoScalingGroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyToLaunchedInstances(java.lang.Boolean applyToLaunchedInstances) {
            this.applyToLaunchedInstances = applyToLaunchedInstances;
            return this;
        }

        /**
         * Sets the value of ExcludeResourceTypes
         * @param excludeResourceTypes An array of Resource Types that will not receive this tag.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeResourceTypes(java.util.List<java.lang.String> excludeResourceTypes) {
            this.excludeResourceTypes = excludeResourceTypes;
            return this;
        }

        /**
         * Sets the value of IncludeResourceTypes
         * @param includeResourceTypes An array of Resource Types that will receive this tag.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeResourceTypes(java.util.List<java.lang.String> includeResourceTypes) {
            this.includeResourceTypes = includeResourceTypes;
            return this;
        }

        /**
         * Sets the value of Priority
         * @param priority Priority of the tag operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TagProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public TagProps build() {
            return new Jsii$Proxy(applyToLaunchedInstances, excludeResourceTypes, includeResourceTypes, priority);
        }
    }

    /**
     * An implementation for {@link TagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagProps {
        private final java.lang.Boolean applyToLaunchedInstances;
        private final java.util.List<java.lang.String> excludeResourceTypes;
        private final java.util.List<java.lang.String> includeResourceTypes;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.applyToLaunchedInstances = this.jsiiGet("applyToLaunchedInstances", java.lang.Boolean.class);
            this.excludeResourceTypes = this.jsiiGet("excludeResourceTypes", java.util.List.class);
            this.includeResourceTypes = this.jsiiGet("includeResourceTypes", java.util.List.class);
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Boolean applyToLaunchedInstances, java.util.List<java.lang.String> excludeResourceTypes, java.util.List<java.lang.String> includeResourceTypes, java.lang.Number priority) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applyToLaunchedInstances = applyToLaunchedInstances;
            this.excludeResourceTypes = excludeResourceTypes;
            this.includeResourceTypes = includeResourceTypes;
            this.priority = priority;
        }

        @Override
        public java.lang.Boolean getApplyToLaunchedInstances() {
            return this.applyToLaunchedInstances;
        }

        @Override
        public java.util.List<java.lang.String> getExcludeResourceTypes() {
            return this.excludeResourceTypes;
        }

        @Override
        public java.util.List<java.lang.String> getIncludeResourceTypes() {
            return this.includeResourceTypes;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getApplyToLaunchedInstances() != null) {
                obj.set("applyToLaunchedInstances", om.valueToTree(this.getApplyToLaunchedInstances()));
            }
            if (this.getExcludeResourceTypes() != null) {
                obj.set("excludeResourceTypes", om.valueToTree(this.getExcludeResourceTypes()));
            }
            if (this.getIncludeResourceTypes() != null) {
                obj.set("includeResourceTypes", om.valueToTree(this.getIncludeResourceTypes()));
            }
            if (this.getPriority() != null) {
                obj.set("priority", om.valueToTree(this.getPriority()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TagProps.Jsii$Proxy that = (TagProps.Jsii$Proxy) o;

            if (this.applyToLaunchedInstances != null ? !this.applyToLaunchedInstances.equals(that.applyToLaunchedInstances) : that.applyToLaunchedInstances != null) return false;
            if (this.excludeResourceTypes != null ? !this.excludeResourceTypes.equals(that.excludeResourceTypes) : that.excludeResourceTypes != null) return false;
            if (this.includeResourceTypes != null ? !this.includeResourceTypes.equals(that.includeResourceTypes) : that.includeResourceTypes != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public int hashCode() {
            int result = this.applyToLaunchedInstances != null ? this.applyToLaunchedInstances.hashCode() : 0;
            result = 31 * result + (this.excludeResourceTypes != null ? this.excludeResourceTypes.hashCode() : 0);
            result = 31 * result + (this.includeResourceTypes != null ? this.includeResourceTypes.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
