package software.amazon.awscdk.core;

/**
 * Options to the resolve() operation.
 * 
 * NOT the same as the ResolveContext; ResolveContext is exposed to Token
 * implementors and resolution hooks, whereas this struct is just to bundle
 * a number of things that would otherwise be arguments to resolve() in a
 * readable way.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:13:28.340Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResolveOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The resolver to apply to any resolvable tokens found.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.ITokenResolver getResolver();

    /**
     * The scope from which resolution is performed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.IConstruct getScope();

    /**
     * Whether the resolution is being executed during the prepare phase or not.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getPreparing();

    /**
     * @return a {@link Builder} of {@link ResolveOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResolveOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.core.ITokenResolver resolver;
        private software.amazon.awscdk.core.IConstruct scope;
        private java.lang.Boolean preparing;

        /**
         * Sets the value of Resolver
         * @param resolver The resolver to apply to any resolvable tokens found. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolver(software.amazon.awscdk.core.ITokenResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        /**
         * Sets the value of Scope
         * @param scope The scope from which resolution is performed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.amazon.awscdk.core.IConstruct scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of Preparing
         * @param preparing Whether the resolution is being executed during the prepare phase or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preparing(java.lang.Boolean preparing) {
            this.preparing = preparing;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResolveOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ResolveOptions build() {
            return new Jsii$Proxy(resolver, scope, preparing);
        }
    }

    /**
     * An implementation for {@link ResolveOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResolveOptions {
        private final software.amazon.awscdk.core.ITokenResolver resolver;
        private final software.amazon.awscdk.core.IConstruct scope;
        private final java.lang.Boolean preparing;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.resolver = this.jsiiGet("resolver", software.amazon.awscdk.core.ITokenResolver.class);
            this.scope = this.jsiiGet("scope", software.amazon.awscdk.core.IConstruct.class);
            this.preparing = this.jsiiGet("preparing", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.core.ITokenResolver resolver, software.amazon.awscdk.core.IConstruct scope, java.lang.Boolean preparing) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resolver = java.util.Objects.requireNonNull(resolver, "resolver is required");
            this.scope = java.util.Objects.requireNonNull(scope, "scope is required");
            this.preparing = preparing;
        }

        @Override
        public software.amazon.awscdk.core.ITokenResolver getResolver() {
            return this.resolver;
        }

        @Override
        public software.amazon.awscdk.core.IConstruct getScope() {
            return this.scope;
        }

        @Override
        public java.lang.Boolean getPreparing() {
            return this.preparing;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("resolver", om.valueToTree(this.getResolver()));
            obj.set("scope", om.valueToTree(this.getScope()));
            if (this.getPreparing() != null) {
                obj.set("preparing", om.valueToTree(this.getPreparing()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResolveOptions.Jsii$Proxy that = (ResolveOptions.Jsii$Proxy) o;

            if (!resolver.equals(that.resolver)) return false;
            if (!scope.equals(that.scope)) return false;
            return this.preparing != null ? this.preparing.equals(that.preparing) : that.preparing == null;
        }

        @Override
        public int hashCode() {
            int result = this.resolver.hashCode();
            result = 31 * result + (this.scope.hashCode());
            result = 31 * result + (this.preparing != null ? this.preparing.hashCode() : 0);
            return result;
        }
    }
}
