package software.amazon.awscdk.core;

/**
 * A rule can include a RuleCondition property and must include an Assertions property. For each rule, you can define only one rule condition; you can define one or more asserts within the Assertions property. You define a rule condition and assertions by using rule-specific intrinsic functions.
 * 
 * You can use the following rule-specific intrinsic functions to define rule conditions and assertions:
 * 
 *   Fn::And
 *   Fn::Contains
 *   Fn::EachMemberEquals
 *   Fn::EachMemberIn
 *   Fn::Equals
 *   Fn::If
 *   Fn::Not
 *   Fn::Or
 *   Fn::RefAll
 *   Fn::ValueOf
 *   Fn::ValueOfAll
 * 
 * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:13:28.324Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Assertions which define the rule.
     * 
     * Default: - No assertions for the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> getAssertions();

    /**
     * If the rule condition evaluates to false, the rule doesn't take effect. If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
     * 
     * Default: - Rule's assertions will always take effect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.ICfnConditionExpression getRuleCondition();

    /**
     * @return a {@link Builder} of {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> assertions;
        private software.amazon.awscdk.core.ICfnConditionExpression ruleCondition;

        /**
         * Sets the value of Assertions
         * @param assertions Assertions which define the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assertions(java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> assertions) {
            this.assertions = assertions;
            return this;
        }

        /**
         * Sets the value of RuleCondition
         * @param ruleCondition If the rule condition evaluates to false, the rule doesn't take effect. If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleCondition(software.amazon.awscdk.core.ICfnConditionExpression ruleCondition) {
            this.ruleCondition = ruleCondition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnRuleProps build() {
            return new Jsii$Proxy(assertions, ruleCondition);
        }
    }

    /**
     * An implementation for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRuleProps {
        private final java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> assertions;
        private final software.amazon.awscdk.core.ICfnConditionExpression ruleCondition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.assertions = this.jsiiGet("assertions", java.util.List.class);
            this.ruleCondition = this.jsiiGet("ruleCondition", software.amazon.awscdk.core.ICfnConditionExpression.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> assertions, software.amazon.awscdk.core.ICfnConditionExpression ruleCondition) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assertions = assertions;
            this.ruleCondition = ruleCondition;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> getAssertions() {
            return this.assertions;
        }

        @Override
        public software.amazon.awscdk.core.ICfnConditionExpression getRuleCondition() {
            return this.ruleCondition;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getAssertions() != null) {
                obj.set("assertions", om.valueToTree(this.getAssertions()));
            }
            if (this.getRuleCondition() != null) {
                obj.set("ruleCondition", om.valueToTree(this.getRuleCondition()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRuleProps.Jsii$Proxy that = (CfnRuleProps.Jsii$Proxy) o;

            if (this.assertions != null ? !this.assertions.equals(that.assertions) : that.assertions != null) return false;
            return this.ruleCondition != null ? this.ruleCondition.equals(that.ruleCondition) : that.ruleCondition == null;
        }

        @Override
        public int hashCode() {
            int result = this.assertions != null ? this.assertions.hashCode() : 0;
            result = 31 * result + (this.ruleCondition != null ? this.ruleCondition.hashCode() : 0);
            return result;
        }
    }
}
