package software.amazon.awscdk.core;

/**
 * Properties for a Dynamic Reference.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:13:28.315Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDynamicReferenceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The reference key of the dynamic reference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getReferenceKey();

    /**
     * The service to retrieve the dynamic reference from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.CfnDynamicReferenceService getService();

    /**
     * @return a {@link Builder} of {@link CfnDynamicReferenceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDynamicReferenceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String referenceKey;
        private software.amazon.awscdk.core.CfnDynamicReferenceService service;

        /**
         * Sets the value of ReferenceKey
         * @param referenceKey The reference key of the dynamic reference. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder referenceKey(java.lang.String referenceKey) {
            this.referenceKey = referenceKey;
            return this;
        }

        /**
         * Sets the value of Service
         * @param service The service to retrieve the dynamic reference from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.core.CfnDynamicReferenceService service) {
            this.service = service;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDynamicReferenceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnDynamicReferenceProps build() {
            return new Jsii$Proxy(referenceKey, service);
        }
    }

    /**
     * An implementation for {@link CfnDynamicReferenceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDynamicReferenceProps {
        private final java.lang.String referenceKey;
        private final software.amazon.awscdk.core.CfnDynamicReferenceService service;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.referenceKey = this.jsiiGet("referenceKey", java.lang.String.class);
            this.service = this.jsiiGet("service", software.amazon.awscdk.core.CfnDynamicReferenceService.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String referenceKey, software.amazon.awscdk.core.CfnDynamicReferenceService service) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.referenceKey = java.util.Objects.requireNonNull(referenceKey, "referenceKey is required");
            this.service = java.util.Objects.requireNonNull(service, "service is required");
        }

        @Override
        public java.lang.String getReferenceKey() {
            return this.referenceKey;
        }

        @Override
        public software.amazon.awscdk.core.CfnDynamicReferenceService getService() {
            return this.service;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("referenceKey", om.valueToTree(this.getReferenceKey()));
            obj.set("service", om.valueToTree(this.getService()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDynamicReferenceProps.Jsii$Proxy that = (CfnDynamicReferenceProps.Jsii$Proxy) o;

            if (!referenceKey.equals(that.referenceKey)) return false;
            return this.service.equals(that.service);
        }

        @Override
        public int hashCode() {
            int result = this.referenceKey.hashCode();
            result = 31 * result + (this.service.hashCode());
            return result;
        }
    }
}
