package software.amazon.awscdk.core;

/**
 * Configuration properties for DefaultStackSynthesizer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.41.0 (build a274beb)", date = "2021-10-29T17:34:26.119Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.DefaultStackSynthesizerProps")
@software.amazon.jsii.Jsii.Proxy(DefaultStackSynthesizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DefaultStackSynthesizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Bootstrap stack version SSM parameter.
     * <p>
     * The placeholder <code>${Qualifier}</code> will be replaced with the value of qualifier.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBootstrapStackVersionSsmParameter() {
        return null;
    }

    /**
     * bucketPrefix to use while storing S3 Assets.
     * <p>
     * Default: - DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
        return null;
    }

    /**
     * The role CloudFormation will assume when deploying the Stack.
     * <p>
     * You must supply this if you have given a non-standard name to the execution role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudFormationExecutionRole() {
        return null;
    }

    /**
     * The role to assume to initiate a deployment in this environment.
     * <p>
     * You must supply this if you have given a non-standard name to the publishing role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeployRoleArn() {
        return null;
    }

    /**
     * External ID to use when assuming role for cloudformation deployments.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeployRoleExternalId() {
        return null;
    }

    /**
     * A prefix to use while tagging and uploading Docker images to ECR.
     * <p>
     * This does not add any separators - the source hash will be appended to
     * this string directly.
     * <p>
     * Default: - DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerTagPrefix() {
        return null;
    }

    /**
     * (deprecated) Name of the CloudFormation Export with the asset key name.
     * <p>
     * You must supply this if you have given a non-standard name to the KMS key export
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME
     * <p>
     * @deprecated This property is not used anymore
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getFileAssetKeyArnExportName() {
        return null;
    }

    /**
     * External ID to use when assuming role for file asset publishing.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileAssetPublishingExternalId() {
        return null;
    }

    /**
     * The role to use to publish file assets to the S3 bucket in this environment.
     * <p>
     * You must supply this if you have given a non-standard name to the publishing role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileAssetPublishingRoleArn() {
        return null;
    }

    /**
     * Name of the S3 bucket to hold file assets.
     * <p>
     * You must supply this if you have given a non-standard name to the staging bucket.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileAssetsBucketName() {
        return null;
    }

    /**
     * Whether to add a Rule to the stack template verifying the bootstrap stack version.
     * <p>
     * This generally should be left set to <code>true</code>, unless you explicitly
     * want to be able to deploy to an unbootstrapped environment.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGenerateBootstrapVersionRule() {
        return null;
    }

    /**
     * External ID to use when assuming role for image asset publishing.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageAssetPublishingExternalId() {
        return null;
    }

    /**
     * The role to use to publish image assets to the ECR repository in this environment.
     * <p>
     * You must supply this if you have given a non-standard name to the publishing role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageAssetPublishingRoleArn() {
        return null;
    }

    /**
     * Name of the ECR repository to hold Docker Image assets.
     * <p>
     * You must supply this if you have given a non-standard name to the ECR repository.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageAssetsRepositoryName() {
        return null;
    }

    /**
     * The role to use to look up values from the target AWS account during synthesis.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLookupRoleArn() {
        return null;
    }

    /**
     * Qualifier to disambiguate multiple environments in the same account.
     * <p>
     * You can use this and leave the other naming properties empty if you have deployed
     * the bootstrap environment with standard names but only differnet qualifiers.
     * <p>
     * Default: - Value of context key '
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQualifier() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DefaultStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DefaultStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DefaultStackSynthesizerProps> {
        private java.lang.String bootstrapStackVersionSsmParameter;
        private java.lang.String bucketPrefix;
        private java.lang.String cloudFormationExecutionRole;
        private java.lang.String deployRoleArn;
        private java.lang.String deployRoleExternalId;
        private java.lang.String dockerTagPrefix;
        private java.lang.String fileAssetKeyArnExportName;
        private java.lang.String fileAssetPublishingExternalId;
        private java.lang.String fileAssetPublishingRoleArn;
        private java.lang.String fileAssetsBucketName;
        private java.lang.Boolean generateBootstrapVersionRule;
        private java.lang.String imageAssetPublishingExternalId;
        private java.lang.String imageAssetPublishingRoleArn;
        private java.lang.String imageAssetsRepositoryName;
        private java.lang.String lookupRoleArn;
        private java.lang.String qualifier;

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getBootstrapStackVersionSsmParameter}
         * @param bootstrapStackVersionSsmParameter Bootstrap stack version SSM parameter.
         *                                          The placeholder <code>${Qualifier}</code> will be replaced with the value of qualifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapStackVersionSsmParameter(java.lang.String bootstrapStackVersionSsmParameter) {
            this.bootstrapStackVersionSsmParameter = bootstrapStackVersionSsmParameter;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getBucketPrefix}
         * @param bucketPrefix bucketPrefix to use while storing S3 Assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketPrefix(java.lang.String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getCloudFormationExecutionRole}
         * @param cloudFormationExecutionRole The role CloudFormation will assume when deploying the Stack.
         *                                    You must supply this if you have given a non-standard name to the execution role.
         *                                    <p>
         *                                    The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                    be replaced with the values of qualifier and the stack's account and region,
         *                                    respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRole(java.lang.String cloudFormationExecutionRole) {
            this.cloudFormationExecutionRole = cloudFormationExecutionRole;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getDeployRoleArn}
         * @param deployRoleArn The role to assume to initiate a deployment in this environment.
         *                      You must supply this if you have given a non-standard name to the publishing role.
         *                      <p>
         *                      The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                      be replaced with the values of qualifier and the stack's account and region,
         *                      respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleArn(java.lang.String deployRoleArn) {
            this.deployRoleArn = deployRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getDeployRoleExternalId}
         * @param deployRoleExternalId External ID to use when assuming role for cloudformation deployments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleExternalId(java.lang.String deployRoleExternalId) {
            this.deployRoleExternalId = deployRoleExternalId;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getDockerTagPrefix}
         * @param dockerTagPrefix A prefix to use while tagging and uploading Docker images to ECR.
         *                        This does not add any separators - the source hash will be appended to
         *                        this string directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerTagPrefix(java.lang.String dockerTagPrefix) {
            this.dockerTagPrefix = dockerTagPrefix;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getFileAssetKeyArnExportName}
         * @param fileAssetKeyArnExportName Name of the CloudFormation Export with the asset key name.
         *                                  You must supply this if you have given a non-standard name to the KMS key export
         *                                  <p>
         *                                  The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                  be replaced with the values of qualifier and the stack's account and region,
         *                                  respectively.
         * @return {@code this}
         * @deprecated This property is not used anymore
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder fileAssetKeyArnExportName(java.lang.String fileAssetKeyArnExportName) {
            this.fileAssetKeyArnExportName = fileAssetKeyArnExportName;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getFileAssetPublishingExternalId}
         * @param fileAssetPublishingExternalId External ID to use when assuming role for file asset publishing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetPublishingExternalId(java.lang.String fileAssetPublishingExternalId) {
            this.fileAssetPublishingExternalId = fileAssetPublishingExternalId;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getFileAssetPublishingRoleArn}
         * @param fileAssetPublishingRoleArn The role to use to publish file assets to the S3 bucket in this environment.
         *                                   You must supply this if you have given a non-standard name to the publishing role.
         *                                   <p>
         *                                   The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                   be replaced with the values of qualifier and the stack's account and region,
         *                                   respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetPublishingRoleArn(java.lang.String fileAssetPublishingRoleArn) {
            this.fileAssetPublishingRoleArn = fileAssetPublishingRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getFileAssetsBucketName}
         * @param fileAssetsBucketName Name of the S3 bucket to hold file assets.
         *                             You must supply this if you have given a non-standard name to the staging bucket.
         *                             <p>
         *                             The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                             be replaced with the values of qualifier and the stack's account and region,
         *                             respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetsBucketName(java.lang.String fileAssetsBucketName) {
            this.fileAssetsBucketName = fileAssetsBucketName;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getGenerateBootstrapVersionRule}
         * @param generateBootstrapVersionRule Whether to add a Rule to the stack template verifying the bootstrap stack version.
         *                                     This generally should be left set to <code>true</code>, unless you explicitly
         *                                     want to be able to deploy to an unbootstrapped environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateBootstrapVersionRule(java.lang.Boolean generateBootstrapVersionRule) {
            this.generateBootstrapVersionRule = generateBootstrapVersionRule;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getImageAssetPublishingExternalId}
         * @param imageAssetPublishingExternalId External ID to use when assuming role for image asset publishing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetPublishingExternalId(java.lang.String imageAssetPublishingExternalId) {
            this.imageAssetPublishingExternalId = imageAssetPublishingExternalId;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getImageAssetPublishingRoleArn}
         * @param imageAssetPublishingRoleArn The role to use to publish image assets to the ECR repository in this environment.
         *                                    You must supply this if you have given a non-standard name to the publishing role.
         *                                    <p>
         *                                    The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                    be replaced with the values of qualifier and the stack's account and region,
         *                                    respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetPublishingRoleArn(java.lang.String imageAssetPublishingRoleArn) {
            this.imageAssetPublishingRoleArn = imageAssetPublishingRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getImageAssetsRepositoryName}
         * @param imageAssetsRepositoryName Name of the ECR repository to hold Docker Image assets.
         *                                  You must supply this if you have given a non-standard name to the ECR repository.
         *                                  <p>
         *                                  The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                  be replaced with the values of qualifier and the stack's account and region,
         *                                  respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetsRepositoryName(java.lang.String imageAssetsRepositoryName) {
            this.imageAssetsRepositoryName = imageAssetsRepositoryName;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getLookupRoleArn}
         * @param lookupRoleArn The role to use to look up values from the target AWS account during synthesis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleArn(java.lang.String lookupRoleArn) {
            this.lookupRoleArn = lookupRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getQualifier}
         * @param qualifier Qualifier to disambiguate multiple environments in the same account.
         *                  You can use this and leave the other naming properties empty if you have deployed
         *                  the bootstrap environment with standard names but only differnet qualifiers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(java.lang.String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DefaultStackSynthesizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DefaultStackSynthesizerProps build() {
            return new Jsii$Proxy(bootstrapStackVersionSsmParameter, bucketPrefix, cloudFormationExecutionRole, deployRoleArn, deployRoleExternalId, dockerTagPrefix, fileAssetKeyArnExportName, fileAssetPublishingExternalId, fileAssetPublishingRoleArn, fileAssetsBucketName, generateBootstrapVersionRule, imageAssetPublishingExternalId, imageAssetPublishingRoleArn, imageAssetsRepositoryName, lookupRoleArn, qualifier);
        }
    }

    /**
     * An implementation for {@link DefaultStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultStackSynthesizerProps {
        private final java.lang.String bootstrapStackVersionSsmParameter;
        private final java.lang.String bucketPrefix;
        private final java.lang.String cloudFormationExecutionRole;
        private final java.lang.String deployRoleArn;
        private final java.lang.String deployRoleExternalId;
        private final java.lang.String dockerTagPrefix;
        private final java.lang.String fileAssetKeyArnExportName;
        private final java.lang.String fileAssetPublishingExternalId;
        private final java.lang.String fileAssetPublishingRoleArn;
        private final java.lang.String fileAssetsBucketName;
        private final java.lang.Boolean generateBootstrapVersionRule;
        private final java.lang.String imageAssetPublishingExternalId;
        private final java.lang.String imageAssetPublishingRoleArn;
        private final java.lang.String imageAssetsRepositoryName;
        private final java.lang.String lookupRoleArn;
        private final java.lang.String qualifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bootstrapStackVersionSsmParameter = software.amazon.jsii.Kernel.get(this, "bootstrapStackVersionSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudFormationExecutionRole = software.amazon.jsii.Kernel.get(this, "cloudFormationExecutionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deployRoleArn = software.amazon.jsii.Kernel.get(this, "deployRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deployRoleExternalId = software.amazon.jsii.Kernel.get(this, "deployRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerTagPrefix = software.amazon.jsii.Kernel.get(this, "dockerTagPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileAssetKeyArnExportName = software.amazon.jsii.Kernel.get(this, "fileAssetKeyArnExportName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileAssetPublishingExternalId = software.amazon.jsii.Kernel.get(this, "fileAssetPublishingExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileAssetPublishingRoleArn = software.amazon.jsii.Kernel.get(this, "fileAssetPublishingRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileAssetsBucketName = software.amazon.jsii.Kernel.get(this, "fileAssetsBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.generateBootstrapVersionRule = software.amazon.jsii.Kernel.get(this, "generateBootstrapVersionRule", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.imageAssetPublishingExternalId = software.amazon.jsii.Kernel.get(this, "imageAssetPublishingExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageAssetPublishingRoleArn = software.amazon.jsii.Kernel.get(this, "imageAssetPublishingRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageAssetsRepositoryName = software.amazon.jsii.Kernel.get(this, "imageAssetsRepositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lookupRoleArn = software.amazon.jsii.Kernel.get(this, "lookupRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.qualifier = software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String bootstrapStackVersionSsmParameter, final java.lang.String bucketPrefix, final java.lang.String cloudFormationExecutionRole, final java.lang.String deployRoleArn, final java.lang.String deployRoleExternalId, final java.lang.String dockerTagPrefix, final java.lang.String fileAssetKeyArnExportName, final java.lang.String fileAssetPublishingExternalId, final java.lang.String fileAssetPublishingRoleArn, final java.lang.String fileAssetsBucketName, final java.lang.Boolean generateBootstrapVersionRule, final java.lang.String imageAssetPublishingExternalId, final java.lang.String imageAssetPublishingRoleArn, final java.lang.String imageAssetsRepositoryName, final java.lang.String lookupRoleArn, final java.lang.String qualifier) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bootstrapStackVersionSsmParameter = bootstrapStackVersionSsmParameter;
            this.bucketPrefix = bucketPrefix;
            this.cloudFormationExecutionRole = cloudFormationExecutionRole;
            this.deployRoleArn = deployRoleArn;
            this.deployRoleExternalId = deployRoleExternalId;
            this.dockerTagPrefix = dockerTagPrefix;
            this.fileAssetKeyArnExportName = fileAssetKeyArnExportName;
            this.fileAssetPublishingExternalId = fileAssetPublishingExternalId;
            this.fileAssetPublishingRoleArn = fileAssetPublishingRoleArn;
            this.fileAssetsBucketName = fileAssetsBucketName;
            this.generateBootstrapVersionRule = generateBootstrapVersionRule;
            this.imageAssetPublishingExternalId = imageAssetPublishingExternalId;
            this.imageAssetPublishingRoleArn = imageAssetPublishingRoleArn;
            this.imageAssetsRepositoryName = imageAssetsRepositoryName;
            this.lookupRoleArn = lookupRoleArn;
            this.qualifier = qualifier;
        }

        @Override
        public final java.lang.String getBootstrapStackVersionSsmParameter() {
            return this.bootstrapStackVersionSsmParameter;
        }

        @Override
        public final java.lang.String getBucketPrefix() {
            return this.bucketPrefix;
        }

        @Override
        public final java.lang.String getCloudFormationExecutionRole() {
            return this.cloudFormationExecutionRole;
        }

        @Override
        public final java.lang.String getDeployRoleArn() {
            return this.deployRoleArn;
        }

        @Override
        public final java.lang.String getDeployRoleExternalId() {
            return this.deployRoleExternalId;
        }

        @Override
        public final java.lang.String getDockerTagPrefix() {
            return this.dockerTagPrefix;
        }

        @Override
        public final java.lang.String getFileAssetKeyArnExportName() {
            return this.fileAssetKeyArnExportName;
        }

        @Override
        public final java.lang.String getFileAssetPublishingExternalId() {
            return this.fileAssetPublishingExternalId;
        }

        @Override
        public final java.lang.String getFileAssetPublishingRoleArn() {
            return this.fileAssetPublishingRoleArn;
        }

        @Override
        public final java.lang.String getFileAssetsBucketName() {
            return this.fileAssetsBucketName;
        }

        @Override
        public final java.lang.Boolean getGenerateBootstrapVersionRule() {
            return this.generateBootstrapVersionRule;
        }

        @Override
        public final java.lang.String getImageAssetPublishingExternalId() {
            return this.imageAssetPublishingExternalId;
        }

        @Override
        public final java.lang.String getImageAssetPublishingRoleArn() {
            return this.imageAssetPublishingRoleArn;
        }

        @Override
        public final java.lang.String getImageAssetsRepositoryName() {
            return this.imageAssetsRepositoryName;
        }

        @Override
        public final java.lang.String getLookupRoleArn() {
            return this.lookupRoleArn;
        }

        @Override
        public final java.lang.String getQualifier() {
            return this.qualifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBootstrapStackVersionSsmParameter() != null) {
                data.set("bootstrapStackVersionSsmParameter", om.valueToTree(this.getBootstrapStackVersionSsmParameter()));
            }
            if (this.getBucketPrefix() != null) {
                data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
            }
            if (this.getCloudFormationExecutionRole() != null) {
                data.set("cloudFormationExecutionRole", om.valueToTree(this.getCloudFormationExecutionRole()));
            }
            if (this.getDeployRoleArn() != null) {
                data.set("deployRoleArn", om.valueToTree(this.getDeployRoleArn()));
            }
            if (this.getDeployRoleExternalId() != null) {
                data.set("deployRoleExternalId", om.valueToTree(this.getDeployRoleExternalId()));
            }
            if (this.getDockerTagPrefix() != null) {
                data.set("dockerTagPrefix", om.valueToTree(this.getDockerTagPrefix()));
            }
            if (this.getFileAssetKeyArnExportName() != null) {
                data.set("fileAssetKeyArnExportName", om.valueToTree(this.getFileAssetKeyArnExportName()));
            }
            if (this.getFileAssetPublishingExternalId() != null) {
                data.set("fileAssetPublishingExternalId", om.valueToTree(this.getFileAssetPublishingExternalId()));
            }
            if (this.getFileAssetPublishingRoleArn() != null) {
                data.set("fileAssetPublishingRoleArn", om.valueToTree(this.getFileAssetPublishingRoleArn()));
            }
            if (this.getFileAssetsBucketName() != null) {
                data.set("fileAssetsBucketName", om.valueToTree(this.getFileAssetsBucketName()));
            }
            if (this.getGenerateBootstrapVersionRule() != null) {
                data.set("generateBootstrapVersionRule", om.valueToTree(this.getGenerateBootstrapVersionRule()));
            }
            if (this.getImageAssetPublishingExternalId() != null) {
                data.set("imageAssetPublishingExternalId", om.valueToTree(this.getImageAssetPublishingExternalId()));
            }
            if (this.getImageAssetPublishingRoleArn() != null) {
                data.set("imageAssetPublishingRoleArn", om.valueToTree(this.getImageAssetPublishingRoleArn()));
            }
            if (this.getImageAssetsRepositoryName() != null) {
                data.set("imageAssetsRepositoryName", om.valueToTree(this.getImageAssetsRepositoryName()));
            }
            if (this.getLookupRoleArn() != null) {
                data.set("lookupRoleArn", om.valueToTree(this.getLookupRoleArn()));
            }
            if (this.getQualifier() != null) {
                data.set("qualifier", om.valueToTree(this.getQualifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.DefaultStackSynthesizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DefaultStackSynthesizerProps.Jsii$Proxy that = (DefaultStackSynthesizerProps.Jsii$Proxy) o;

            if (this.bootstrapStackVersionSsmParameter != null ? !this.bootstrapStackVersionSsmParameter.equals(that.bootstrapStackVersionSsmParameter) : that.bootstrapStackVersionSsmParameter != null) return false;
            if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
            if (this.cloudFormationExecutionRole != null ? !this.cloudFormationExecutionRole.equals(that.cloudFormationExecutionRole) : that.cloudFormationExecutionRole != null) return false;
            if (this.deployRoleArn != null ? !this.deployRoleArn.equals(that.deployRoleArn) : that.deployRoleArn != null) return false;
            if (this.deployRoleExternalId != null ? !this.deployRoleExternalId.equals(that.deployRoleExternalId) : that.deployRoleExternalId != null) return false;
            if (this.dockerTagPrefix != null ? !this.dockerTagPrefix.equals(that.dockerTagPrefix) : that.dockerTagPrefix != null) return false;
            if (this.fileAssetKeyArnExportName != null ? !this.fileAssetKeyArnExportName.equals(that.fileAssetKeyArnExportName) : that.fileAssetKeyArnExportName != null) return false;
            if (this.fileAssetPublishingExternalId != null ? !this.fileAssetPublishingExternalId.equals(that.fileAssetPublishingExternalId) : that.fileAssetPublishingExternalId != null) return false;
            if (this.fileAssetPublishingRoleArn != null ? !this.fileAssetPublishingRoleArn.equals(that.fileAssetPublishingRoleArn) : that.fileAssetPublishingRoleArn != null) return false;
            if (this.fileAssetsBucketName != null ? !this.fileAssetsBucketName.equals(that.fileAssetsBucketName) : that.fileAssetsBucketName != null) return false;
            if (this.generateBootstrapVersionRule != null ? !this.generateBootstrapVersionRule.equals(that.generateBootstrapVersionRule) : that.generateBootstrapVersionRule != null) return false;
            if (this.imageAssetPublishingExternalId != null ? !this.imageAssetPublishingExternalId.equals(that.imageAssetPublishingExternalId) : that.imageAssetPublishingExternalId != null) return false;
            if (this.imageAssetPublishingRoleArn != null ? !this.imageAssetPublishingRoleArn.equals(that.imageAssetPublishingRoleArn) : that.imageAssetPublishingRoleArn != null) return false;
            if (this.imageAssetsRepositoryName != null ? !this.imageAssetsRepositoryName.equals(that.imageAssetsRepositoryName) : that.imageAssetsRepositoryName != null) return false;
            if (this.lookupRoleArn != null ? !this.lookupRoleArn.equals(that.lookupRoleArn) : that.lookupRoleArn != null) return false;
            return this.qualifier != null ? this.qualifier.equals(that.qualifier) : that.qualifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bootstrapStackVersionSsmParameter != null ? this.bootstrapStackVersionSsmParameter.hashCode() : 0;
            result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
            result = 31 * result + (this.cloudFormationExecutionRole != null ? this.cloudFormationExecutionRole.hashCode() : 0);
            result = 31 * result + (this.deployRoleArn != null ? this.deployRoleArn.hashCode() : 0);
            result = 31 * result + (this.deployRoleExternalId != null ? this.deployRoleExternalId.hashCode() : 0);
            result = 31 * result + (this.dockerTagPrefix != null ? this.dockerTagPrefix.hashCode() : 0);
            result = 31 * result + (this.fileAssetKeyArnExportName != null ? this.fileAssetKeyArnExportName.hashCode() : 0);
            result = 31 * result + (this.fileAssetPublishingExternalId != null ? this.fileAssetPublishingExternalId.hashCode() : 0);
            result = 31 * result + (this.fileAssetPublishingRoleArn != null ? this.fileAssetPublishingRoleArn.hashCode() : 0);
            result = 31 * result + (this.fileAssetsBucketName != null ? this.fileAssetsBucketName.hashCode() : 0);
            result = 31 * result + (this.generateBootstrapVersionRule != null ? this.generateBootstrapVersionRule.hashCode() : 0);
            result = 31 * result + (this.imageAssetPublishingExternalId != null ? this.imageAssetPublishingExternalId.hashCode() : 0);
            result = 31 * result + (this.imageAssetPublishingRoleArn != null ? this.imageAssetPublishingRoleArn.hashCode() : 0);
            result = 31 * result + (this.imageAssetsRepositoryName != null ? this.imageAssetsRepositoryName.hashCode() : 0);
            result = 31 * result + (this.lookupRoleArn != null ? this.lookupRoleArn.hashCode() : 0);
            result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
            return result;
        }
    }
}
