package software.amazon.awscdk.core;

/**
 * The location of the published docker image.
 * 
 * This is where the image can be
 * consumed at runtime.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T19:44:26.021Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DockerImageAssetLocation extends software.amazon.jsii.JsiiSerializable {

    /**
     * The URI of the image in Amazon ECR.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getImageUri();

    /**
     * The name of the ECR repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getRepositoryName();

    /**
     * @return a {@link Builder} of {@link DockerImageAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerImageAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String imageUri;
        private java.lang.String repositoryName;

        /**
         * Sets the value of ImageUri
         * @param imageUri The URI of the image in Amazon ECR. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageUri(java.lang.String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        /**
         * Sets the value of RepositoryName
         * @param repositoryName The name of the ECR repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageAssetLocation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public DockerImageAssetLocation build() {
            return new Jsii$Proxy(imageUri, repositoryName);
        }
    }

    /**
     * An implementation for {@link DockerImageAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerImageAssetLocation {
        private final java.lang.String imageUri;
        private final java.lang.String repositoryName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.imageUri = this.jsiiGet("imageUri", java.lang.String.class);
            this.repositoryName = this.jsiiGet("repositoryName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String imageUri, java.lang.String repositoryName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.imageUri = java.util.Objects.requireNonNull(imageUri, "imageUri is required");
            this.repositoryName = java.util.Objects.requireNonNull(repositoryName, "repositoryName is required");
        }

        @Override
        public java.lang.String getImageUri() {
            return this.imageUri;
        }

        @Override
        public java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("imageUri", om.valueToTree(this.getImageUri()));
            obj.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerImageAssetLocation.Jsii$Proxy that = (DockerImageAssetLocation.Jsii$Proxy) o;

            if (!imageUri.equals(that.imageUri)) return false;
            return this.repositoryName.equals(that.repositoryName);
        }

        @Override
        public int hashCode() {
            int result = this.imageUri.hashCode();
            result = 31 * result + (this.repositoryName.hashCode());
            return result;
        }
    }
}
