package software.amazon.awscdk.core;

/**
 * Represents the amount of digital storage.
 * <p>
 * The amount can be specified either as a literal value (e.g: <code>10</code>) which
 * cannot be negative, or as an unresolved number token.
 * <p>
 * When the amount is passed as a token, unit conversion is not possible.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.39.0 (build 8af72c2)", date = "2021-10-14T05:48:34.195Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Size")
public class Size extends software.amazon.jsii.JsiiObject {

    protected Size(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Size(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a Storage representing an amount gibibytes.
     * <p>
     * 1 GiB = 1024 MiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of gibibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size gibibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "gibibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount kibibytes.
     * <p>
     * 1 KiB = 1024 bytes
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of kibibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size kibibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "kibibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount mebibytes.
     * <p>
     * 1 MiB = 1024 KiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of mebibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size mebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "mebibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * (deprecated) Create a Storage representing an amount pebibytes.
     * <p>
     * 1 PiB = 1024 TiB
     * <p>
     * @deprecated use `pebibytes` instead
     * @param amount This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size pebibyte(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "pebibyte", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount pebibytes.
     * <p>
     * 1 PiB = 1024 TiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of pebibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size pebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "pebibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount tebibytes.
     * <p>
     * 1 TiB = 1024 GiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of tebibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size tebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Size.class, "tebibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Return this storage as a total number of gibibytes.
     * <p>
     * @return the quantity of bytes expressed in gibibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toGibibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toGibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return this storage as a total number of gibibytes.
     * <p>
     * @return the quantity of bytes expressed in gibibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toGibibytes() {
        return software.amazon.jsii.Kernel.call(this, "toGibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return this storage as a total number of kibibytes.
     * <p>
     * @return the quantity of bytes expressed in kibibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toKibibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toKibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return this storage as a total number of kibibytes.
     * <p>
     * @return the quantity of bytes expressed in kibibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toKibibytes() {
        return software.amazon.jsii.Kernel.call(this, "toKibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return this storage as a total number of mebibytes.
     * <p>
     * @return the quantity of bytes expressed in mebibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toMebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return this storage as a total number of mebibytes.
     * <p>
     * @return the quantity of bytes expressed in mebibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMebibytes() {
        return software.amazon.jsii.Kernel.call(this, "toMebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return this storage as a total number of pebibytes.
     * <p>
     * @return the quantity of bytes expressed in pebibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toPebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toPebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return this storage as a total number of pebibytes.
     * <p>
     * @return the quantity of bytes expressed in pebibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toPebibytes() {
        return software.amazon.jsii.Kernel.call(this, "toPebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return this storage as a total number of tebibytes.
     * <p>
     * @return the quantity of bytes expressed in tebibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toTebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toTebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return this storage as a total number of tebibytes.
     * <p>
     * @return the quantity of bytes expressed in tebibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toTebibytes() {
        return software.amazon.jsii.Kernel.call(this, "toTebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }
}
