package software.amazon.awscdk.core;

/**
 * The attributes of the ECS Service being deployed.
 * <p>
 * Type of the {&#64;link CfnCodeDeployBlueGreenApplication.ecsAttributes} property.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.35.0 (build 6ebef96)", date = "2021-10-05T13:28:31.383Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnCodeDeployBlueGreenEcsAttributes")
@software.amazon.jsii.Jsii.Proxy(CfnCodeDeployBlueGreenEcsAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCodeDeployBlueGreenEcsAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The logical IDs of the blue and green, respectively, AWS::ECS::TaskDefinition task definitions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTaskDefinitions();

    /**
     * The logical IDs of the blue and green, respectively, AWS::ECS::TaskSet task sets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTaskSets();

    /**
     * The traffic routing configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnTrafficRouting getTrafficRouting();

    /**
     * @return a {@link Builder} of {@link CfnCodeDeployBlueGreenEcsAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCodeDeployBlueGreenEcsAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCodeDeployBlueGreenEcsAttributes> {
        private java.util.List<java.lang.String> taskDefinitions;
        private java.util.List<java.lang.String> taskSets;
        private software.amazon.awscdk.core.CfnTrafficRouting trafficRouting;

        /**
         * Sets the value of {@link CfnCodeDeployBlueGreenEcsAttributes#getTaskDefinitions}
         * @param taskDefinitions The logical IDs of the blue and green, respectively, AWS::ECS::TaskDefinition task definitions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinitions(java.util.List<java.lang.String> taskDefinitions) {
            this.taskDefinitions = taskDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeDeployBlueGreenEcsAttributes#getTaskSets}
         * @param taskSets The logical IDs of the blue and green, respectively, AWS::ECS::TaskSet task sets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskSets(java.util.List<java.lang.String> taskSets) {
            this.taskSets = taskSets;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeDeployBlueGreenEcsAttributes#getTrafficRouting}
         * @param trafficRouting The traffic routing configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficRouting(software.amazon.awscdk.core.CfnTrafficRouting trafficRouting) {
            this.trafficRouting = trafficRouting;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCodeDeployBlueGreenEcsAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCodeDeployBlueGreenEcsAttributes build() {
            return new Jsii$Proxy(taskDefinitions, taskSets, trafficRouting);
        }
    }

    /**
     * An implementation for {@link CfnCodeDeployBlueGreenEcsAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCodeDeployBlueGreenEcsAttributes {
        private final java.util.List<java.lang.String> taskDefinitions;
        private final java.util.List<java.lang.String> taskSets;
        private final software.amazon.awscdk.core.CfnTrafficRouting trafficRouting;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.taskDefinitions = software.amazon.jsii.Kernel.get(this, "taskDefinitions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.taskSets = software.amazon.jsii.Kernel.get(this, "taskSets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.trafficRouting = software.amazon.jsii.Kernel.get(this, "trafficRouting", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTrafficRouting.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.util.List<java.lang.String> taskDefinitions, final java.util.List<java.lang.String> taskSets, final software.amazon.awscdk.core.CfnTrafficRouting trafficRouting) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.taskDefinitions = java.util.Objects.requireNonNull(taskDefinitions, "taskDefinitions is required");
            this.taskSets = java.util.Objects.requireNonNull(taskSets, "taskSets is required");
            this.trafficRouting = java.util.Objects.requireNonNull(trafficRouting, "trafficRouting is required");
        }

        @Override
        public final java.util.List<java.lang.String> getTaskDefinitions() {
            return this.taskDefinitions;
        }

        @Override
        public final java.util.List<java.lang.String> getTaskSets() {
            return this.taskSets;
        }

        @Override
        public final software.amazon.awscdk.core.CfnTrafficRouting getTrafficRouting() {
            return this.trafficRouting;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("taskDefinitions", om.valueToTree(this.getTaskDefinitions()));
            data.set("taskSets", om.valueToTree(this.getTaskSets()));
            data.set("trafficRouting", om.valueToTree(this.getTrafficRouting()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CfnCodeDeployBlueGreenEcsAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCodeDeployBlueGreenEcsAttributes.Jsii$Proxy that = (CfnCodeDeployBlueGreenEcsAttributes.Jsii$Proxy) o;

            if (!taskDefinitions.equals(that.taskDefinitions)) return false;
            if (!taskSets.equals(that.taskSets)) return false;
            return this.trafficRouting.equals(that.trafficRouting);
        }

        @Override
        public final int hashCode() {
            int result = this.taskDefinitions.hashCode();
            result = 31 * result + (this.taskSets.hashCode());
            result = 31 * result + (this.trafficRouting.hashCode());
            return result;
        }
    }
}
