package software.amazon.awscdk.core;

/**
 * Work with secret values in the CDK.
 * <p>
 * Secret values in the CDK (such as those retrieved from SecretsManager) are
 * represented as regular strings, just like other values that are only
 * available at deployment time.
 * <p>
 * To help you avoid accidental mistakes which would lead to you putting your
 * secret values directly into a CloudFormation template, constructs that take
 * secret values will not allow you to pass in a literal secret value. They do
 * so by calling <code>Secret.assertSafeSecret()</code>.
 * <p>
 * You can escape the check by calling <code>Secret.plainText()</code>, but doing
 * so is highly discouraged.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-29T20:30:20.467Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.SecretValue")
public class SecretValue extends software.amazon.awscdk.core.Intrinsic {

    protected SecretValue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecretValue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param value This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SecretValue(final @org.jetbrains.annotations.NotNull java.lang.Object value, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IntrinsicProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { value, options });
    }

    /**
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SecretValue(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { value });
    }

    /**
     * Obtain the secret value through a CloudFormation dynamic reference.
     * <p>
     * If possible, use <code>SecretValue.ssmSecure</code> or <code>SecretValue.secretsManager</code> directly.
     * <p>
     * @param ref The dynamic reference to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue cfnDynamicReference(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnDynamicReference ref) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "cfnDynamicReference", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(ref, "ref is required") });
    }

    /**
     * Obtain the secret value through a CloudFormation parameter.
     * <p>
     * Generally, this is not a recommended approach. AWS Secrets Manager is the
     * recommended way to reference secrets.
     * <p>
     * @param param The CloudFormation parameter to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue cfnParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnParameter param) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "cfnParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(param, "param is required") });
    }

    /**
     * Construct a literal secret value for use with secret-aware constructs.
     * <p>
     * <em>Do not use this method for any secrets that you care about.</em>
     * <p>
     * The only reasonable use case for using this method is when you are testing.
     * <p>
     * @param secret This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue plainText(final @org.jetbrains.annotations.NotNull java.lang.String secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "plainText", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * Creates a `SecretValue` with a value which is dynamically loaded from AWS Secrets Manager.
     * <p>
     * @param secretId The ID or ARN of the secret. This parameter is required.
     * @param options Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue secretsManager(final @org.jetbrains.annotations.NotNull java.lang.String secretId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SecretsManagerSecretOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "secretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(secretId, "secretId is required"), options });
    }

    /**
     * Creates a `SecretValue` with a value which is dynamically loaded from AWS Secrets Manager.
     * <p>
     * @param secretId The ID or ARN of the secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue secretsManager(final @org.jetbrains.annotations.NotNull java.lang.String secretId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "secretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(secretId, "secretId is required") });
    }

    /**
     * Use a secret value stored from a Systems Manager (SSM) parameter.
     * <p>
     * @param parameterName The name of the parameter in the Systems Manager Parameter Store. This parameter is required.
     * @param version An integer that specifies the version of the parameter to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue ssmSecure(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.SecretValue.class, "ssmSecure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.SecretValue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.SecretValue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param value This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.Object value) {
            return new Builder(value);
        }

        private final java.lang.Object value;
        private software.amazon.awscdk.core.IntrinsicProps.Builder options;

        private Builder(final java.lang.Object value) {
            this.value = value;
        }

        /**
         * Capture the stack trace of where this token is created.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param stackTrace Capture the stack trace of where this token is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackTrace(final java.lang.Boolean stackTrace) {
            this.options().stackTrace(stackTrace);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.SecretValue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.SecretValue build() {
            return new software.amazon.awscdk.core.SecretValue(
                this.value,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.core.IntrinsicProps.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.core.IntrinsicProps.Builder();
            }
            return this.options;
        }
    }
}
