package software.amazon.awscdk.core;

/**
 * The type of asset hash.
 * <p>
 * NOTE: the hash is used in order to identify a specific revision of the asset, and
 * used for optimizing and caching deployment activities related to this asset such as
 * packaging, uploading to Amazon S3, etc.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-01T11:10:19.018Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.AssetHashType")
public enum AssetHashType {
    /**
     * Based on the content of the source path.
     * <p>
     * When bundling, use <code>SOURCE</code> when the content of the bundling output is not
     * stable across repeated bundling operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SOURCE,
    /**
     * (deprecated) Based on the content of the bundled path.
     * <p>
     * @deprecated use `OUTPUT` instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    BUNDLE,
    /**
     * Based on the content of the bundling output.
     * <p>
     * Use <code>OUTPUT</code> when the source of the asset is a top level folder containing
     * code and/or dependencies that are not directly linked to the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OUTPUT,
    /**
     * Use a custom hash.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CUSTOM,
}
