/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.DefaultStackSynthesizerProps;
import software.amazon.awscdk.core.DockerImageAssetLocation;
import software.amazon.awscdk.core.DockerImageAssetSource;
import software.amazon.awscdk.core.FileAssetLocation;
import software.amazon.awscdk.core.FileAssetSource;
import software.amazon.awscdk.core.ISynthesisSession;
import software.amazon.awscdk.core.Stack;
import software.amazon.awscdk.core.StackSynthesizer;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/core.DefaultStackSynthesizer")
public class DefaultStackSynthesizer
extends StackSynthesizer {
    public static final String DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER", (NativeType)NativeType.forClass(String.class));
    public static final String DEFAULT_CLOUDFORMATION_ROLE_ARN = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_CLOUDFORMATION_ROLE_ARN", (NativeType)NativeType.forClass(String.class));
    public static final String DEFAULT_DEPLOY_ROLE_ARN = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_DEPLOY_ROLE_ARN", (NativeType)NativeType.forClass(String.class));
    public static final String DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME", (NativeType)NativeType.forClass(String.class));
    public static final String DEFAULT_FILE_ASSET_PREFIX = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_FILE_ASSET_PREFIX", (NativeType)NativeType.forClass(String.class));
    public static final String DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN", (NativeType)NativeType.forClass(String.class));
    public static final String DEFAULT_FILE_ASSETS_BUCKET_NAME = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_FILE_ASSETS_BUCKET_NAME", (NativeType)NativeType.forClass(String.class));
    public static final String DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN", (NativeType)NativeType.forClass(String.class));
    public static final String DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME", (NativeType)NativeType.forClass(String.class));
    public static final String DEFAULT_LOOKUP_ROLE_ARN = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_LOOKUP_ROLE_ARN", (NativeType)NativeType.forClass(String.class));
    public static final String DEFAULT_QUALIFIER = (String)JsiiObject.jsiiStaticGet(DefaultStackSynthesizer.class, (String)"DEFAULT_QUALIFIER", (NativeType)NativeType.forClass(String.class));

    protected DefaultStackSynthesizer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DefaultStackSynthesizer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DefaultStackSynthesizer(@Nullable DefaultStackSynthesizerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{props});
    }

    public DefaultStackSynthesizer() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    @Override
    @NotNull
    public DockerImageAssetLocation addDockerImageAsset(@NotNull DockerImageAssetSource asset) {
        return (DockerImageAssetLocation)Kernel.call((Object)this, (String)"addDockerImageAsset", (NativeType)NativeType.forClass(DockerImageAssetLocation.class), (Object[])new Object[]{Objects.requireNonNull(asset, "asset is required")});
    }

    @Override
    @NotNull
    public FileAssetLocation addFileAsset(@NotNull FileAssetSource asset) {
        return (FileAssetLocation)Kernel.call((Object)this, (String)"addFileAsset", (NativeType)NativeType.forClass(FileAssetLocation.class), (Object[])new Object[]{Objects.requireNonNull(asset, "asset is required")});
    }

    @Override
    public void bind(@NotNull Stack stack) {
        Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(stack, "stack is required")});
    }

    @Override
    public void synthesize(@NotNull ISynthesisSession session) {
        Kernel.call((Object)this, (String)"synthesize", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(session, "session is required")});
    }

    @Override
    protected void synthesizeStackTemplate(@NotNull Stack stack, @NotNull ISynthesisSession session) {
        Kernel.call((Object)this, (String)"synthesizeStackTemplate", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(stack, "stack is required"), Objects.requireNonNull(session, "session is required")});
    }

    @NotNull
    public String getCloudFormationExecutionRoleArn() {
        return (String)Kernel.get((Object)this, (String)"cloudFormationExecutionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getDeployRoleArn() {
        return (String)Kernel.get((Object)this, (String)"deployRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected Stack getStack() {
        return (Stack)Kernel.get((Object)this, (String)"stack", (NativeType)NativeType.forClass(Stack.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DefaultStackSynthesizer> {
        private DefaultStackSynthesizerProps.Builder props;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder bootstrapStackVersionSsmParameter(String bootstrapStackVersionSsmParameter) {
            this.props().bootstrapStackVersionSsmParameter(bootstrapStackVersionSsmParameter);
            return this;
        }

        public Builder bucketPrefix(String bucketPrefix) {
            this.props().bucketPrefix(bucketPrefix);
            return this;
        }

        public Builder cloudFormationExecutionRole(String cloudFormationExecutionRole) {
            this.props().cloudFormationExecutionRole(cloudFormationExecutionRole);
            return this;
        }

        public Builder deployRoleArn(String deployRoleArn) {
            this.props().deployRoleArn(deployRoleArn);
            return this;
        }

        public Builder deployRoleExternalId(String deployRoleExternalId) {
            this.props().deployRoleExternalId(deployRoleExternalId);
            return this;
        }

        @Deprecated
        public Builder fileAssetKeyArnExportName(String fileAssetKeyArnExportName) {
            this.props().fileAssetKeyArnExportName(fileAssetKeyArnExportName);
            return this;
        }

        public Builder fileAssetPublishingExternalId(String fileAssetPublishingExternalId) {
            this.props().fileAssetPublishingExternalId(fileAssetPublishingExternalId);
            return this;
        }

        public Builder fileAssetPublishingRoleArn(String fileAssetPublishingRoleArn) {
            this.props().fileAssetPublishingRoleArn(fileAssetPublishingRoleArn);
            return this;
        }

        public Builder fileAssetsBucketName(String fileAssetsBucketName) {
            this.props().fileAssetsBucketName(fileAssetsBucketName);
            return this;
        }

        public Builder generateBootstrapVersionRule(Boolean generateBootstrapVersionRule) {
            this.props().generateBootstrapVersionRule(generateBootstrapVersionRule);
            return this;
        }

        public Builder imageAssetPublishingExternalId(String imageAssetPublishingExternalId) {
            this.props().imageAssetPublishingExternalId(imageAssetPublishingExternalId);
            return this;
        }

        public Builder imageAssetPublishingRoleArn(String imageAssetPublishingRoleArn) {
            this.props().imageAssetPublishingRoleArn(imageAssetPublishingRoleArn);
            return this;
        }

        public Builder imageAssetsRepositoryName(String imageAssetsRepositoryName) {
            this.props().imageAssetsRepositoryName(imageAssetsRepositoryName);
            return this;
        }

        public Builder lookupRoleArn(String lookupRoleArn) {
            this.props().lookupRoleArn(lookupRoleArn);
            return this;
        }

        public Builder qualifier(String qualifier) {
            this.props().qualifier(qualifier);
            return this;
        }

        public DefaultStackSynthesizer build() {
            return new DefaultStackSynthesizer(this.props != null ? this.props.build() : null);
        }

        private DefaultStackSynthesizerProps.Builder props() {
            if (this.props == null) {
                this.props = new DefaultStackSynthesizerProps.Builder();
            }
            return this.props;
        }
    }
}

