package software.amazon.awscdk.core;

/**
 * Stack artifact options.
 * <p>
 * A subset of <code>cxschema.AwsCloudFormationStackProperties</code> of optional settings that need to be
 * configurable by synthesizers, plus <code>additionalDependencies</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-17T20:03:58.561Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.SynthesizeStackArtifactOptions")
@software.amazon.jsii.Jsii.Proxy(SynthesizeStackArtifactOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SynthesizeStackArtifactOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifiers of additional dependencies.
     * <p>
     * Default: - No additional dependencies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalDependencies() {
        return null;
    }

    /**
     * The role that needs to be assumed to deploy the stack.
     * <p>
     * Default: - No role is assumed (current credentials are used)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssumeRoleArn() {
        return null;
    }

    /**
     * The externalID to use with the assumeRoleArn.
     * <p>
     * Default: - No externalID is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssumeRoleExternalId() {
        return null;
    }

    /**
     * SSM parameter where the bootstrap stack version number can be found.
     * <p>
     * Only used if <code>requiresBootstrapStackVersion</code> is set.
     * <p>
     * <ul>
     * <li>If this value is not set, the bootstrap stack name must be known at
     * deployment time so the stack version can be looked up from the stack
     * outputs.</li>
     * <li>If this value is set, the bootstrap stack can have any name because
     * we won't need to look it up.</li>
     * </ul>
     * <p>
     * Default: - Bootstrap stack version number looked up
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBootstrapStackVersionSsmParameter() {
        return null;
    }

    /**
     * The role that is passed to CloudFormation to execute the change set.
     * <p>
     * Default: - No role is passed (currently assumed role/credentials are used)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudFormationExecutionRoleArn() {
        return null;
    }

    /**
     * Values for CloudFormation stack parameters that should be passed when the stack is deployed.
     * <p>
     * Default: - No parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getParameters() {
        return null;
    }

    /**
     * Version of bootstrap stack required to deploy this stack.
     * <p>
     * Default: - No bootstrap stack required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRequiresBootstrapStackVersion() {
        return null;
    }

    /**
     * If the stack template has already been included in the asset manifest, its asset URL.
     * <p>
     * Default: - Not uploaded yet, upload just before deploying
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStackTemplateAssetObjectUrl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SynthesizeStackArtifactOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SynthesizeStackArtifactOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SynthesizeStackArtifactOptions> {
        private java.util.List<java.lang.String> additionalDependencies;
        private java.lang.String assumeRoleArn;
        private java.lang.String assumeRoleExternalId;
        private java.lang.String bootstrapStackVersionSsmParameter;
        private java.lang.String cloudFormationExecutionRoleArn;
        private java.util.Map<java.lang.String, java.lang.String> parameters;
        private java.lang.Number requiresBootstrapStackVersion;
        private java.lang.String stackTemplateAssetObjectUrl;

        /**
         * Sets the value of {@link SynthesizeStackArtifactOptions#getAdditionalDependencies}
         * @param additionalDependencies Identifiers of additional dependencies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalDependencies(java.util.List<java.lang.String> additionalDependencies) {
            this.additionalDependencies = additionalDependencies;
            return this;
        }

        /**
         * Sets the value of {@link SynthesizeStackArtifactOptions#getAssumeRoleArn}
         * @param assumeRoleArn The role that needs to be assumed to deploy the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleArn(java.lang.String assumeRoleArn) {
            this.assumeRoleArn = assumeRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link SynthesizeStackArtifactOptions#getAssumeRoleExternalId}
         * @param assumeRoleExternalId The externalID to use with the assumeRoleArn.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleExternalId(java.lang.String assumeRoleExternalId) {
            this.assumeRoleExternalId = assumeRoleExternalId;
            return this;
        }

        /**
         * Sets the value of {@link SynthesizeStackArtifactOptions#getBootstrapStackVersionSsmParameter}
         * @param bootstrapStackVersionSsmParameter SSM parameter where the bootstrap stack version number can be found.
         *                                          Only used if <code>requiresBootstrapStackVersion</code> is set.
         *                                          <p>
         *                                          <ul>
         *                                          <li>If this value is not set, the bootstrap stack name must be known at
         *                                          deployment time so the stack version can be looked up from the stack
         *                                          outputs.</li>
         *                                          <li>If this value is set, the bootstrap stack can have any name because
         *                                          we won't need to look it up.</li>
         *                                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapStackVersionSsmParameter(java.lang.String bootstrapStackVersionSsmParameter) {
            this.bootstrapStackVersionSsmParameter = bootstrapStackVersionSsmParameter;
            return this;
        }

        /**
         * Sets the value of {@link SynthesizeStackArtifactOptions#getCloudFormationExecutionRoleArn}
         * @param cloudFormationExecutionRoleArn The role that is passed to CloudFormation to execute the change set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRoleArn(java.lang.String cloudFormationExecutionRoleArn) {
            this.cloudFormationExecutionRoleArn = cloudFormationExecutionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link SynthesizeStackArtifactOptions#getParameters}
         * @param parameters Values for CloudFormation stack parameters that should be passed when the stack is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link SynthesizeStackArtifactOptions#getRequiresBootstrapStackVersion}
         * @param requiresBootstrapStackVersion Version of bootstrap stack required to deploy this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requiresBootstrapStackVersion(java.lang.Number requiresBootstrapStackVersion) {
            this.requiresBootstrapStackVersion = requiresBootstrapStackVersion;
            return this;
        }

        /**
         * Sets the value of {@link SynthesizeStackArtifactOptions#getStackTemplateAssetObjectUrl}
         * @param stackTemplateAssetObjectUrl If the stack template has already been included in the asset manifest, its asset URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackTemplateAssetObjectUrl(java.lang.String stackTemplateAssetObjectUrl) {
            this.stackTemplateAssetObjectUrl = stackTemplateAssetObjectUrl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SynthesizeStackArtifactOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SynthesizeStackArtifactOptions build() {
            return new Jsii$Proxy(additionalDependencies, assumeRoleArn, assumeRoleExternalId, bootstrapStackVersionSsmParameter, cloudFormationExecutionRoleArn, parameters, requiresBootstrapStackVersion, stackTemplateAssetObjectUrl);
        }
    }

    /**
     * An implementation for {@link SynthesizeStackArtifactOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SynthesizeStackArtifactOptions {
        private final java.util.List<java.lang.String> additionalDependencies;
        private final java.lang.String assumeRoleArn;
        private final java.lang.String assumeRoleExternalId;
        private final java.lang.String bootstrapStackVersionSsmParameter;
        private final java.lang.String cloudFormationExecutionRoleArn;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final java.lang.Number requiresBootstrapStackVersion;
        private final java.lang.String stackTemplateAssetObjectUrl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalDependencies = software.amazon.jsii.Kernel.get(this, "additionalDependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.assumeRoleArn = software.amazon.jsii.Kernel.get(this, "assumeRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRoleExternalId = software.amazon.jsii.Kernel.get(this, "assumeRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bootstrapStackVersionSsmParameter = software.amazon.jsii.Kernel.get(this, "bootstrapStackVersionSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudFormationExecutionRoleArn = software.amazon.jsii.Kernel.get(this, "cloudFormationExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requiresBootstrapStackVersion = software.amazon.jsii.Kernel.get(this, "requiresBootstrapStackVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.stackTemplateAssetObjectUrl = software.amazon.jsii.Kernel.get(this, "stackTemplateAssetObjectUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.util.List<java.lang.String> additionalDependencies, final java.lang.String assumeRoleArn, final java.lang.String assumeRoleExternalId, final java.lang.String bootstrapStackVersionSsmParameter, final java.lang.String cloudFormationExecutionRoleArn, final java.util.Map<java.lang.String, java.lang.String> parameters, final java.lang.Number requiresBootstrapStackVersion, final java.lang.String stackTemplateAssetObjectUrl) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalDependencies = additionalDependencies;
            this.assumeRoleArn = assumeRoleArn;
            this.assumeRoleExternalId = assumeRoleExternalId;
            this.bootstrapStackVersionSsmParameter = bootstrapStackVersionSsmParameter;
            this.cloudFormationExecutionRoleArn = cloudFormationExecutionRoleArn;
            this.parameters = parameters;
            this.requiresBootstrapStackVersion = requiresBootstrapStackVersion;
            this.stackTemplateAssetObjectUrl = stackTemplateAssetObjectUrl;
        }

        @Override
        public final java.util.List<java.lang.String> getAdditionalDependencies() {
            return this.additionalDependencies;
        }

        @Override
        public final java.lang.String getAssumeRoleArn() {
            return this.assumeRoleArn;
        }

        @Override
        public final java.lang.String getAssumeRoleExternalId() {
            return this.assumeRoleExternalId;
        }

        @Override
        public final java.lang.String getBootstrapStackVersionSsmParameter() {
            return this.bootstrapStackVersionSsmParameter;
        }

        @Override
        public final java.lang.String getCloudFormationExecutionRoleArn() {
            return this.cloudFormationExecutionRoleArn;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Number getRequiresBootstrapStackVersion() {
            return this.requiresBootstrapStackVersion;
        }

        @Override
        public final java.lang.String getStackTemplateAssetObjectUrl() {
            return this.stackTemplateAssetObjectUrl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalDependencies() != null) {
                data.set("additionalDependencies", om.valueToTree(this.getAdditionalDependencies()));
            }
            if (this.getAssumeRoleArn() != null) {
                data.set("assumeRoleArn", om.valueToTree(this.getAssumeRoleArn()));
            }
            if (this.getAssumeRoleExternalId() != null) {
                data.set("assumeRoleExternalId", om.valueToTree(this.getAssumeRoleExternalId()));
            }
            if (this.getBootstrapStackVersionSsmParameter() != null) {
                data.set("bootstrapStackVersionSsmParameter", om.valueToTree(this.getBootstrapStackVersionSsmParameter()));
            }
            if (this.getCloudFormationExecutionRoleArn() != null) {
                data.set("cloudFormationExecutionRoleArn", om.valueToTree(this.getCloudFormationExecutionRoleArn()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getRequiresBootstrapStackVersion() != null) {
                data.set("requiresBootstrapStackVersion", om.valueToTree(this.getRequiresBootstrapStackVersion()));
            }
            if (this.getStackTemplateAssetObjectUrl() != null) {
                data.set("stackTemplateAssetObjectUrl", om.valueToTree(this.getStackTemplateAssetObjectUrl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.SynthesizeStackArtifactOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SynthesizeStackArtifactOptions.Jsii$Proxy that = (SynthesizeStackArtifactOptions.Jsii$Proxy) o;

            if (this.additionalDependencies != null ? !this.additionalDependencies.equals(that.additionalDependencies) : that.additionalDependencies != null) return false;
            if (this.assumeRoleArn != null ? !this.assumeRoleArn.equals(that.assumeRoleArn) : that.assumeRoleArn != null) return false;
            if (this.assumeRoleExternalId != null ? !this.assumeRoleExternalId.equals(that.assumeRoleExternalId) : that.assumeRoleExternalId != null) return false;
            if (this.bootstrapStackVersionSsmParameter != null ? !this.bootstrapStackVersionSsmParameter.equals(that.bootstrapStackVersionSsmParameter) : that.bootstrapStackVersionSsmParameter != null) return false;
            if (this.cloudFormationExecutionRoleArn != null ? !this.cloudFormationExecutionRoleArn.equals(that.cloudFormationExecutionRoleArn) : that.cloudFormationExecutionRoleArn != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.requiresBootstrapStackVersion != null ? !this.requiresBootstrapStackVersion.equals(that.requiresBootstrapStackVersion) : that.requiresBootstrapStackVersion != null) return false;
            return this.stackTemplateAssetObjectUrl != null ? this.stackTemplateAssetObjectUrl.equals(that.stackTemplateAssetObjectUrl) : that.stackTemplateAssetObjectUrl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalDependencies != null ? this.additionalDependencies.hashCode() : 0;
            result = 31 * result + (this.assumeRoleArn != null ? this.assumeRoleArn.hashCode() : 0);
            result = 31 * result + (this.assumeRoleExternalId != null ? this.assumeRoleExternalId.hashCode() : 0);
            result = 31 * result + (this.bootstrapStackVersionSsmParameter != null ? this.bootstrapStackVersionSsmParameter.hashCode() : 0);
            result = 31 * result + (this.cloudFormationExecutionRoleArn != null ? this.cloudFormationExecutionRoleArn.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.requiresBootstrapStackVersion != null ? this.requiresBootstrapStackVersion.hashCode() : 0);
            result = 31 * result + (this.stackTemplateAssetObjectUrl != null ? this.stackTemplateAssetObjectUrl.hashCode() : 0);
            return result;
        }
    }
}
