package software.amazon.awscdk.core;

/**
 * Properties for a tag.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T15:55:56.675Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.TagProps")
@software.amazon.jsii.Jsii.Proxy(TagProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TagProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the tag should be applied to instances in an AutoScalingGroup.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getApplyToLaunchedInstances() {
        return null;
    }

    /**
     * An array of Resource Types that will not receive this tag.
     * <p>
     * An empty array will allow this tag to be applied to all resources. A
     * non-empty array will apply this tag only if the Resource type is not in
     * this array.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeResourceTypes() {
        return null;
    }

    /**
     * An array of Resource Types that will receive this tag.
     * <p>
     * An empty array will match any Resource. A non-empty array will apply this
     * tag only to Resource types that are included in this array.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludeResourceTypes() {
        return null;
    }

    /**
     * Priority of the tag operation.
     * <p>
     * Higher or equal priority tags will take precedence.
     * <p>
     * Setting priority will enable the user to control tags when they need to not
     * follow the default precedence pattern of last applied and closest to the
     * construct in the tree.
     * <p>
     * Default: Default priorities:
     * - 100 for {@link SetTag}
     * - 200 for {@link RemoveTag}
     * - 50 for tags added directly to CloudFormation resources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TagProps> {
        private java.lang.Boolean applyToLaunchedInstances;
        private java.util.List<java.lang.String> excludeResourceTypes;
        private java.util.List<java.lang.String> includeResourceTypes;
        private java.lang.Number priority;

        /**
         * Sets the value of {@link TagProps#getApplyToLaunchedInstances}
         * @param applyToLaunchedInstances Whether the tag should be applied to instances in an AutoScalingGroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyToLaunchedInstances(java.lang.Boolean applyToLaunchedInstances) {
            this.applyToLaunchedInstances = applyToLaunchedInstances;
            return this;
        }

        /**
         * Sets the value of {@link TagProps#getExcludeResourceTypes}
         * @param excludeResourceTypes An array of Resource Types that will not receive this tag.
         *                             An empty array will allow this tag to be applied to all resources. A
         *                             non-empty array will apply this tag only if the Resource type is not in
         *                             this array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeResourceTypes(java.util.List<java.lang.String> excludeResourceTypes) {
            this.excludeResourceTypes = excludeResourceTypes;
            return this;
        }

        /**
         * Sets the value of {@link TagProps#getIncludeResourceTypes}
         * @param includeResourceTypes An array of Resource Types that will receive this tag.
         *                             An empty array will match any Resource. A non-empty array will apply this
         *                             tag only to Resource types that are included in this array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeResourceTypes(java.util.List<java.lang.String> includeResourceTypes) {
            this.includeResourceTypes = includeResourceTypes;
            return this;
        }

        /**
         * Sets the value of {@link TagProps#getPriority}
         * @param priority Priority of the tag operation.
         *                 Higher or equal priority tags will take precedence.
         *                 <p>
         *                 Setting priority will enable the user to control tags when they need to not
         *                 follow the default precedence pattern of last applied and closest to the
         *                 construct in the tree.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TagProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TagProps build() {
            return new Jsii$Proxy(applyToLaunchedInstances, excludeResourceTypes, includeResourceTypes, priority);
        }
    }

    /**
     * An implementation for {@link TagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagProps {
        private final java.lang.Boolean applyToLaunchedInstances;
        private final java.util.List<java.lang.String> excludeResourceTypes;
        private final java.util.List<java.lang.String> includeResourceTypes;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applyToLaunchedInstances = software.amazon.jsii.Kernel.get(this, "applyToLaunchedInstances", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.excludeResourceTypes = software.amazon.jsii.Kernel.get(this, "excludeResourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.includeResourceTypes = software.amazon.jsii.Kernel.get(this, "includeResourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Boolean applyToLaunchedInstances, final java.util.List<java.lang.String> excludeResourceTypes, final java.util.List<java.lang.String> includeResourceTypes, final java.lang.Number priority) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applyToLaunchedInstances = applyToLaunchedInstances;
            this.excludeResourceTypes = excludeResourceTypes;
            this.includeResourceTypes = includeResourceTypes;
            this.priority = priority;
        }

        @Override
        public final java.lang.Boolean getApplyToLaunchedInstances() {
            return this.applyToLaunchedInstances;
        }

        @Override
        public final java.util.List<java.lang.String> getExcludeResourceTypes() {
            return this.excludeResourceTypes;
        }

        @Override
        public final java.util.List<java.lang.String> getIncludeResourceTypes() {
            return this.includeResourceTypes;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApplyToLaunchedInstances() != null) {
                data.set("applyToLaunchedInstances", om.valueToTree(this.getApplyToLaunchedInstances()));
            }
            if (this.getExcludeResourceTypes() != null) {
                data.set("excludeResourceTypes", om.valueToTree(this.getExcludeResourceTypes()));
            }
            if (this.getIncludeResourceTypes() != null) {
                data.set("includeResourceTypes", om.valueToTree(this.getIncludeResourceTypes()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.TagProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TagProps.Jsii$Proxy that = (TagProps.Jsii$Proxy) o;

            if (this.applyToLaunchedInstances != null ? !this.applyToLaunchedInstances.equals(that.applyToLaunchedInstances) : that.applyToLaunchedInstances != null) return false;
            if (this.excludeResourceTypes != null ? !this.excludeResourceTypes.equals(that.excludeResourceTypes) : that.excludeResourceTypes != null) return false;
            if (this.includeResourceTypes != null ? !this.includeResourceTypes.equals(that.includeResourceTypes) : that.includeResourceTypes != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applyToLaunchedInstances != null ? this.applyToLaunchedInstances.hashCode() : 0;
            result = 31 * result + (this.excludeResourceTypes != null ? this.excludeResourceTypes.hashCode() : 0);
            result = 31 * result + (this.includeResourceTypes != null ? this.includeResourceTypes.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
