package software.amazon.awscdk.core;

/**
 * Possible values for a resource's Removal Policy.
 * <p>
 * The removal policy controls what happens to the resource if it stops being
 * managed by CloudFormation. This can happen in one of three situations:
 * <p>
 * <ul>
 * <li>The resource is removed from the template, so CloudFormation stops managing it;</li>
 * <li>A change to the resource is made that requires it to be replaced, so CloudFormation stops
 * managing it;</li>
 * <li>The stack is deleted, so CloudFormation stops managing all resources in it.</li>
 * </ul>
 * <p>
 * The Removal Policy applies to all above cases.
 * <p>
 * Many stateful resources in the AWS Construct Library will accept a
 * <code>removalPolicy</code> as a property, typically defaulting it to <code>RETAIN</code>.
 * <p>
 * If the AWS Construct Library resource does not accept a <code>removalPolicy</code>
 * argument, you can always configure it by using the escape hatch mechanism,
 * as shown in the following example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object cfnBucket = (Object)bucket.node.findChild("Resource");
 * cfnBucket.applyRemovalPolicy(cdk.RemovalPolicy.getDESTROY());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-07-02T00:23:01.650Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.RemovalPolicy")
public enum RemovalPolicy {
    /**
     * This is the default removal policy.
     * <p>
     * It means that when the resource is
     * removed from the app, it will be physically destroyed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DESTROY,
    /**
     * This uses the 'Retain' DeletionPolicy, which will cause the resource to be retained in the account, but orphaned from the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RETAIN,
    /**
     * This retention policy deletes the resource, but saves a snapshot of its data before deleting, so that it can be re-created later.
     * <p>
     * Only available for some stateful resources,
     * like databases, EFS volumes, etc.
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SNAPSHOT,
}
