package software.amazon.awscdk.core;

/**
 * A root construct which represents a single CloudFormation stack.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-28T21:13:48.337Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Stack")
public class Stack extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.core.ITaggable {

    protected Stack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new stack.
     * <p>
     * @param scope Parent of this stack, usually an `App` or a `Stage`, but could be any construct.
     * @param id The construct ID of this stack.
     * @param props Stack properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stack(final @org.jetbrains.annotations.Nullable software.constructs.Construct scope, final @org.jetbrains.annotations.Nullable java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.StackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { scope, id, props });
    }

    /**
     * Creates a new stack.
     * <p>
     * @param scope Parent of this stack, usually an `App` or a `Stage`, but could be any construct.
     * @param id The construct ID of this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stack(final @org.jetbrains.annotations.Nullable software.constructs.Construct scope, final @org.jetbrains.annotations.Nullable java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { scope, id });
    }

    /**
     * Creates a new stack.
     * <p>
     * @param scope Parent of this stack, usually an `App` or a `Stage`, but could be any construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stack(final @org.jetbrains.annotations.Nullable software.constructs.Construct scope) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { scope });
    }

    /**
     * Creates a new stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stack() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Return whether the given object is a Stack.
     * <p>
     * We do attribute detection since we can't reliably use 'instanceof'.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isStack(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Stack.class, "isStack", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Looks up the first stack scope in which `construct` is defined.
     * <p>
     * Fails if there is no stack up the tree.
     * <p>
     * @param construct The construct to start the search from. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack of(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct construct) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Stack.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * Add a dependency between this stack and another stack.
     * <p>
     * This can be used to define dependencies between any two stacks within an
     * app, and also supports nested stacks.
     * <p>
     * @param target This parameter is required.
     * @param reason
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack target, final @org.jetbrains.annotations.Nullable java.lang.String reason) {
        software.amazon.jsii.Kernel.call(this, "addDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required"), reason });
    }

    /**
     * Add a dependency between this stack and another stack.
     * <p>
     * This can be used to define dependencies between any two stacks within an
     * app, and also supports nested stacks.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack target) {
        software.amazon.jsii.Kernel.call(this, "addDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * (deprecated) Register a docker image asset on this Stack.
     * <p>
     * @deprecated Use `stack.synthesizer.addDockerImageAsset()` if you are calling,
     * and a different `IStackSynthesizer` class if you are implementing.
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * (deprecated) Register a file asset on this Stack.
     * <p>
     * @deprecated Use `stack.synthesizer.addFileAsset()` if you are calling,
     * and a different IStackSynthesizer class if you are implementing.
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Add a Transform to this stack. A Transform is a macro that AWS CloudFormation uses to process your template.
     * <p>
     * Duplicate values are removed when stack is synthesized.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * stack.addTransform("AWS::Serverless-2016-10-31");}</pre></blockquote>
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-section-structure.html
     * @param transform The transform to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTransform(final @org.jetbrains.annotations.NotNull java.lang.String transform) {
        software.amazon.jsii.Kernel.call(this, "addTransform", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(transform, "transform is required") });
    }

    /**
     * Returns the naming scheme used to allocate logical IDs.
     * <p>
     * By default, uses
     * the <code>HashedAddressingScheme</code> but this method can be overridden to customize
     * this behavior.
     * <p>
     * In order to make sure logical IDs are unique and stable, we hash the resource
     * construct tree path (i.e. toplevel/secondlevel/.../myresource) and add it as
     * a suffix to the path components joined without a separator (CloudFormation
     * IDs only allow alphanumeric characters).
     * <p>
     * The result will be:
     * <p>
     * &lt;path.join('')&gt;&lt;md5(path.join('/')&gt;
     * "human"      "hash"
     * <p>
     * If the "human" part of the ID exceeds 240 characters, we simply trim it so
     * the total ID doesn't exceed CloudFormation's 255 character limit.
     * <p>
     * We only take 8 characters from the md5 hash (0.000005 chance of collision).
     * <p>
     * Special cases:
     * <p>
     * <ul>
     * <li>If the path only contains a single component (i.e. it's a top-level
     * resource), we won't add the hash to it. The hash is not needed for
     * disamiguation and also, it allows for a more straightforward migration an
     * existing CloudFormation template to a CDK stack without logical ID changes
     * (or renames).</li>
     * <li>For aesthetic reasons, if the last components of the path are the same
     * (i.e. <code>L1/L2/Pipeline/Pipeline</code>), they will be de-duplicated to make the
     * resulting human portion of the ID more pleasing: <code>L1L2Pipeline&lt;HASH&gt;</code>
     * instead of <code>L1L2PipelinePipeline&lt;HASH&gt;</code></li>
     * <li>If a component is named "Default" it will be omitted from the path. This
     * allows refactoring higher level abstractions around constructs without affecting
     * the IDs of already deployed resources.</li>
     * <li>If a component is named "Resource" it will be omitted from the user-visible
     * path, but included in the hash. This reduces visual noise in the human readable
     * part of the identifier.</li>
     * </ul>
     * <p>
     * @param cfnElement The element for which the logical ID is allocated. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String allocateLogicalId(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnElement cfnElement) {
        return software.amazon.jsii.Kernel.call(this, "allocateLogicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(cfnElement, "cfnElement is required") });
    }

    /**
     * Create a CloudFormation Export for a value.
     * <p>
     * Returns a string representing the corresponding <code>Fn.importValue()</code>
     * expression for this Export. You can control the name for the export by
     * passing the <code>name</code> option.
     * <p>
     * If you don't supply a value for <code>name</code>, the value you're exporting must be
     * a Resource attribute (for example: <code>bucket.bucketName</code>) and it will be
     * given the same name as the automatic cross-stack reference that would be created
     * if you used the attribute in another Stack.
     * <p>
     * One of the uses for this method is to <em>remove</em> the relationship between
     * two Stacks established by automatic cross-stack references. It will
     * temporarily ensure that the CloudFormation Export still exists while you
     * remove the reference from the consuming stack. After that, you can remove
     * the resource and the manual export.
     * <p>
     * <h2>Example</h2>
     * <p>
     * Here is how the process works. Let's say there are two stacks,
     * <code>producerStack</code> and <code>consumerStack</code>, and <code>producerStack</code> has a bucket
     * called <code>bucket</code>, which is referenced by <code>consumerStack</code> (perhaps because
     * an AWS Lambda Function writes into it, or something like that).
     * <p>
     * It is not safe to remove <code>producerStack.bucket</code> because as the bucket is being
     * deleted, <code>consumerStack</code> might still be using it.
     * <p>
     * Instead, the process takes two deployments:
     * <p>
     * <h3>Deployment 1: break the relationship</h3>
     * <p>
     * <ul>
     * <li>Make sure <code>consumerStack</code> no longer references <code>bucket.bucketName</code> (maybe the consumer
     * stack now uses its own bucket, or it writes to an AWS DynamoDB table, or maybe you just
     * remove the Lambda Function altogether).</li>
     * <li>In the <code>ProducerStack</code> class, call <code>this.exportValue(this.bucket.bucketName)</code>. This
     * will make sure the CloudFormation Export continues to exist while the relationship
     * between the two stacks is being broken.</li>
     * <li>Deploy (this will effectively only change the <code>consumerStack</code>, but it's safe to deploy both).</li>
     * </ul>
     * <p>
     * <h3>Deployment 2: remove the bucket resource</h3>
     * <p>
     * <ul>
     * <li>You are now free to remove the <code>bucket</code> resource from <code>producerStack</code>.</li>
     * <li>Don't forget to remove the <code>exportValue()</code> call as well.</li>
     * <li>Deploy again (this time only the <code>producerStack</code> will be changed -- the bucket will be deleted).</li>
     * </ul>
     * <p>
     * @param exportedValue This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String exportValue(final @org.jetbrains.annotations.NotNull java.lang.Object exportedValue, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.ExportValueOptions options) {
        return software.amazon.jsii.Kernel.call(this, "exportValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { exportedValue, options });
    }

    /**
     * Create a CloudFormation Export for a value.
     * <p>
     * Returns a string representing the corresponding <code>Fn.importValue()</code>
     * expression for this Export. You can control the name for the export by
     * passing the <code>name</code> option.
     * <p>
     * If you don't supply a value for <code>name</code>, the value you're exporting must be
     * a Resource attribute (for example: <code>bucket.bucketName</code>) and it will be
     * given the same name as the automatic cross-stack reference that would be created
     * if you used the attribute in another Stack.
     * <p>
     * One of the uses for this method is to <em>remove</em> the relationship between
     * two Stacks established by automatic cross-stack references. It will
     * temporarily ensure that the CloudFormation Export still exists while you
     * remove the reference from the consuming stack. After that, you can remove
     * the resource and the manual export.
     * <p>
     * <h2>Example</h2>
     * <p>
     * Here is how the process works. Let's say there are two stacks,
     * <code>producerStack</code> and <code>consumerStack</code>, and <code>producerStack</code> has a bucket
     * called <code>bucket</code>, which is referenced by <code>consumerStack</code> (perhaps because
     * an AWS Lambda Function writes into it, or something like that).
     * <p>
     * It is not safe to remove <code>producerStack.bucket</code> because as the bucket is being
     * deleted, <code>consumerStack</code> might still be using it.
     * <p>
     * Instead, the process takes two deployments:
     * <p>
     * <h3>Deployment 1: break the relationship</h3>
     * <p>
     * <ul>
     * <li>Make sure <code>consumerStack</code> no longer references <code>bucket.bucketName</code> (maybe the consumer
     * stack now uses its own bucket, or it writes to an AWS DynamoDB table, or maybe you just
     * remove the Lambda Function altogether).</li>
     * <li>In the <code>ProducerStack</code> class, call <code>this.exportValue(this.bucket.bucketName)</code>. This
     * will make sure the CloudFormation Export continues to exist while the relationship
     * between the two stacks is being broken.</li>
     * <li>Deploy (this will effectively only change the <code>consumerStack</code>, but it's safe to deploy both).</li>
     * </ul>
     * <p>
     * <h3>Deployment 2: remove the bucket resource</h3>
     * <p>
     * <ul>
     * <li>You are now free to remove the <code>bucket</code> resource from <code>producerStack</code>.</li>
     * <li>Don't forget to remove the <code>exportValue()</code> call as well.</li>
     * <li>Deploy again (this time only the <code>producerStack</code> will be changed -- the bucket will be deleted).</li>
     * </ul>
     * <p>
     * @param exportedValue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String exportValue(final @org.jetbrains.annotations.NotNull java.lang.Object exportedValue) {
        return software.amazon.jsii.Kernel.call(this, "exportValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { exportedValue });
    }

    /**
     * Creates an ARN from components.
     * <p>
     * If <code>partition</code>, <code>region</code> or <code>account</code> are not specified, the stack's
     * partition, region and account will be used.
     * <p>
     * If any component is the empty string, an empty string will be inserted
     * into the generated ARN at the location that component corresponds to.
     * <p>
     * The ARN will be formatted as follows:
     * <p>
     * arn:{partition}:{service}:{region}:{account}:{resource}{sep}}{resource-name}
     * <p>
     * The required ARN pieces that are omitted will be taken from the stack that
     * the 'scope' is attached to. If all ARN pieces are supplied, the supplied scope
     * can be 'undefined'.
     * <p>
     * @param components This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String formatArn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents components) {
        return software.amazon.jsii.Kernel.call(this, "formatArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(components, "components is required") });
    }

    /**
     * Allocates a stack-unique CloudFormation-compatible logical identity for a specific resource.
     * <p>
     * This method is called when a <code>CfnElement</code> is created and used to render the
     * initial logical identity of resources. Logical ID renames are applied at
     * this stage.
     * <p>
     * This method uses the protected method <code>allocateLogicalId</code> to render the
     * logical ID for an element. To modify the naming scheme, extend the <code>Stack</code>
     * class and override this method.
     * <p>
     * @param element The CloudFormation element for which a logical identity is needed. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogicalId(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnElement element) {
        return software.amazon.jsii.Kernel.call(this, "getLogicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(element, "element is required") });
    }

    /**
     * (deprecated) Given an ARN, parses it and returns components.
     * <p>
     * IF THE ARN IS A CONCRETE STRING...
     * <p>
     * ...it will be parsed and validated. The separator (<code>sep</code>) will be set to '/'
     * if the 6th component includes a '/', in which case, <code>resource</code> will be set
     * to the value before the '/' and <code>resourceName</code> will be the rest. In case
     * there is no '/', <code>resource</code> will be set to the 6th components and
     * <code>resourceName</code> will be set to the rest of the string.
     * <p>
     * IF THE ARN IS A TOKEN...
     * <p>
     * ...it cannot be validated, since we don't have the actual value yet at the
     * time of this function call. You will have to supply <code>sepIfToken</code> and
     * whether or not ARNs of the expected format usually have resource names
     * in order to parse it properly. The resulting <code>ArnComponents</code> object will
     * contain tokens for the subexpressions of the ARN, not string literals.
     * <p>
     * If the resource name could possibly contain the separator char, the actual
     * resource name cannot be properly parsed. This only occurs if the separator
     * char is '/', and happens for example for S3 object ARNs, IAM Role ARNs,
     * IAM OIDC Provider ARNs, etc. To properly extract the resource name from a
     * Tokenized ARN, you must know the resource type and call
     * <code>Arn.extractResourceName</code>.
     * <p>
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @deprecated use splitArn instead
     * @param arn The ARN string to parse. This parameter is required.
     * @param sepIfToken The separator used to separate resource from resourceName.
     * @param hasName Whether there is a name component in the ARN at all.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents parseArn(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.Nullable java.lang.String sepIfToken, final @org.jetbrains.annotations.Nullable java.lang.Boolean hasName) {
        return software.amazon.jsii.Kernel.call(this, "parseArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ArnComponents.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), sepIfToken, hasName });
    }

    /**
     * (deprecated) Given an ARN, parses it and returns components.
     * <p>
     * IF THE ARN IS A CONCRETE STRING...
     * <p>
     * ...it will be parsed and validated. The separator (<code>sep</code>) will be set to '/'
     * if the 6th component includes a '/', in which case, <code>resource</code> will be set
     * to the value before the '/' and <code>resourceName</code> will be the rest. In case
     * there is no '/', <code>resource</code> will be set to the 6th components and
     * <code>resourceName</code> will be set to the rest of the string.
     * <p>
     * IF THE ARN IS A TOKEN...
     * <p>
     * ...it cannot be validated, since we don't have the actual value yet at the
     * time of this function call. You will have to supply <code>sepIfToken</code> and
     * whether or not ARNs of the expected format usually have resource names
     * in order to parse it properly. The resulting <code>ArnComponents</code> object will
     * contain tokens for the subexpressions of the ARN, not string literals.
     * <p>
     * If the resource name could possibly contain the separator char, the actual
     * resource name cannot be properly parsed. This only occurs if the separator
     * char is '/', and happens for example for S3 object ARNs, IAM Role ARNs,
     * IAM OIDC Provider ARNs, etc. To properly extract the resource name from a
     * Tokenized ARN, you must know the resource type and call
     * <code>Arn.extractResourceName</code>.
     * <p>
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @deprecated use splitArn instead
     * @param arn The ARN string to parse. This parameter is required.
     * @param sepIfToken The separator used to separate resource from resourceName.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents parseArn(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.Nullable java.lang.String sepIfToken) {
        return software.amazon.jsii.Kernel.call(this, "parseArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ArnComponents.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), sepIfToken });
    }

    /**
     * (deprecated) Given an ARN, parses it and returns components.
     * <p>
     * IF THE ARN IS A CONCRETE STRING...
     * <p>
     * ...it will be parsed and validated. The separator (<code>sep</code>) will be set to '/'
     * if the 6th component includes a '/', in which case, <code>resource</code> will be set
     * to the value before the '/' and <code>resourceName</code> will be the rest. In case
     * there is no '/', <code>resource</code> will be set to the 6th components and
     * <code>resourceName</code> will be set to the rest of the string.
     * <p>
     * IF THE ARN IS A TOKEN...
     * <p>
     * ...it cannot be validated, since we don't have the actual value yet at the
     * time of this function call. You will have to supply <code>sepIfToken</code> and
     * whether or not ARNs of the expected format usually have resource names
     * in order to parse it properly. The resulting <code>ArnComponents</code> object will
     * contain tokens for the subexpressions of the ARN, not string literals.
     * <p>
     * If the resource name could possibly contain the separator char, the actual
     * resource name cannot be properly parsed. This only occurs if the separator
     * char is '/', and happens for example for S3 object ARNs, IAM Role ARNs,
     * IAM OIDC Provider ARNs, etc. To properly extract the resource name from a
     * Tokenized ARN, you must know the resource type and call
     * <code>Arn.extractResourceName</code>.
     * <p>
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @deprecated use splitArn instead
     * @param arn The ARN string to parse. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents parseArn(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.Kernel.call(this, "parseArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ArnComponents.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * (deprecated) Deprecated.
     * <p>
     * @return reference itself without any change
     * @see https://github.com/aws/aws-cdk/pull/7187
     * @deprecated cross reference handling has been moved to `App.prepare()`.
     * @param _sourceStack This parameter is required.
     * @param reference This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable prepareCrossReference(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack _sourceStack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Reference reference) {
        return software.amazon.jsii.Kernel.call(this, "prepareCrossReference", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(_sourceStack, "_sourceStack is required"), java.util.Objects.requireNonNull(reference, "reference is required") });
    }

    /**
     * Rename a generated logical identities.
     * <p>
     * To modify the naming scheme strategy, extend the <code>Stack</code> class and
     * override the <code>allocateLogicalId</code> method.
     * <p>
     * @param oldId This parameter is required.
     * @param newId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void renameLogicalId(final @org.jetbrains.annotations.NotNull java.lang.String oldId, final @org.jetbrains.annotations.NotNull java.lang.String newId) {
        software.amazon.jsii.Kernel.call(this, "renameLogicalId", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(oldId, "oldId is required"), java.util.Objects.requireNonNull(newId, "newId is required") });
    }

    /**
     * (deprecated) DEPRECATED.
     * <p>
     * @deprecated use `reportMissingContextKey()`
     * @param report This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void reportMissingContext(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.MissingContext report) {
        software.amazon.jsii.Kernel.call(this, "reportMissingContext", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(report, "report is required") });
    }

    /**
     * Indicate that a context key was expected.
     * <p>
     * Contains instructions which will be emitted into the cloud assembly on how
     * the key should be supplied.
     * <p>
     * @param report The set of parameters needed to obtain the context. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void reportMissingContextKey(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.MissingContext report) {
        software.amazon.jsii.Kernel.call(this, "reportMissingContextKey", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(report, "report is required") });
    }

    /**
     * Resolve a tokenized value in the context of the current stack.
     * <p>
     * @param obj This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { obj });
    }

    /**
     * Splits the provided ARN into its components.
     * <p>
     * Works both if 'arn' is a string like 'arn:aws:s3:::bucket',
     * and a Token representing a dynamic CloudFormation expression
     * (in which case the returned components will also be dynamic CloudFormation expressions,
     * encoded as Tokens).
     * <p>
     * @param arn the ARN to split into its components. This parameter is required.
     * @param arnFormat the expected format of 'arn' - depends on what format the service 'arn' represents uses. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents splitArn(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnFormat arnFormat) {
        return software.amazon.jsii.Kernel.call(this, "splitArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ArnComponents.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), java.util.Objects.requireNonNull(arnFormat, "arnFormat is required") });
    }

    /**
     * Convert an object, potentially containing tokens, to a JSON string.
     * <p>
     * @param obj This parameter is required.
     * @param space
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toJsonString(final @org.jetbrains.annotations.NotNull java.lang.Object obj, final @org.jetbrains.annotations.Nullable java.lang.Number space) {
        return software.amazon.jsii.Kernel.call(this, "toJsonString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { obj, space });
    }

    /**
     * Convert an object, potentially containing tokens, to a JSON string.
     * <p>
     * @param obj This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toJsonString(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.Kernel.call(this, "toJsonString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { obj });
    }

    /**
     * The AWS account into which this stack will be deployed.
     * <p>
     * This value is resolved according to the following rules:
     * <p>
     * <ol>
     * <li>The value provided to <code>env.account</code> when the stack is defined. This can
     * either be a concerete account (e.g. <code>585695031111</code>) or the
     * <code>Aws.accountId</code> token.</li>
     * <li><code>Aws.accountId</code>, which represents the CloudFormation intrinsic reference
     * <code>{ "Ref": "AWS::AccountId" }</code> encoded as a string token.</li>
     * </ol>
     * <p>
     * Preferably, you should use the return value as an opaque string and not
     * attempt to parse it to implement your logic. If you do, you must first
     * check that it is a concerete value an not an unresolved token. If this
     * value is an unresolved token (<code>Token.isUnresolved(stack.account)</code> returns
     * <code>true</code>), this implies that the user wishes that this stack will synthesize
     * into a <strong>account-agnostic template</strong>. In this case, your code should either
     * fail (throw an error, emit a synth error using <code>Annotations.of(construct).addError()</code>) or
     * implement some other region-agnostic behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccount() {
        return software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the cloud assembly artifact for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getArtifactId() {
        return software.amazon.jsii.Kernel.get(this, "artifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the list of AZs that are available in the AWS environment (account/region) associated with this stack.
     * <p>
     * If the stack is environment-agnostic (either account and/or region are
     * tokens), this property will return an array with 2 tokens that will resolve
     * at deploy-time to the first two availability zones returned from CloudFormation's
     * <code>Fn::GetAZs</code> intrinsic function.
     * <p>
     * If they are not available in the context, returns a set of dummy values and
     * reports them as missing, and let the CLI resolve them by calling EC2
     * <code>DescribeAvailabilityZones</code> on the target environment.
     * <p>
     * To specify a different strategy for selecting availability zones override this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Return the stacks this stack depends on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.Stack> getDependencies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class))));
    }

    /**
     * The environment coordinates in which this stack is deployed.
     * <p>
     * In the form
     * <code>aws://account/region</code>. Use <code>stack.account</code> and <code>stack.region</code> to obtain
     * the specific values, no need to parse.
     * <p>
     * You can use this value to determine if two stacks are targeting the same
     * environment.
     * <p>
     * If either <code>stack.account</code> or <code>stack.region</code> are not concrete values (e.g.
     * <code>Aws.account</code> or <code>Aws.region</code>) the special strings <code>unknown-account</code> and/or
     * <code>unknown-region</code> will be used respectively to indicate this stack is
     * region/account-agnostic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates if this is a nested stack, in which case `parentStack` will include a reference to it's parent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getNested() {
        return software.amazon.jsii.Kernel.get(this, "nested", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Returns the list of notification Amazon Resource Names (ARNs) for the current stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getNotificationArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "notificationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The partition in which this stack is defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPartition() {
        return software.amazon.jsii.Kernel.get(this, "partition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS region into which this stack will be deployed (e.g. `us-west-2`).
     * <p>
     * This value is resolved according to the following rules:
     * <p>
     * <ol>
     * <li>The value provided to <code>env.region</code> when the stack is defined. This can
     * either be a concerete region (e.g. <code>us-west-2</code>) or the <code>Aws.region</code>
     * token.</li>
     * <li><code>Aws.region</code>, which is represents the CloudFormation intrinsic reference
     * <code>{ "Ref": "AWS::Region" }</code> encoded as a string token.</li>
     * </ol>
     * <p>
     * Preferably, you should use the return value as an opaque string and not
     * attempt to parse it to implement your logic. If you do, you must first
     * check that it is a concerete value an not an unresolved token. If this
     * value is an unresolved token (<code>Token.isUnresolved(stack.region)</code> returns
     * <code>true</code>), this implies that the user wishes that this stack will synthesize
     * into a <strong>region-agnostic template</strong>. In this case, your code should either
     * fail (throw an error, emit a synth error using <code>Annotations.of(construct).addError()</code>) or
     * implement some other region-agnostic behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the stack.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated. See https://github.com/aws/jsii/issues/826
     * // After resolving, looks like
     * "arn:aws:cloudformation:us-west-2:123456789012:stack/teststack/51af3dc0-da77-11e4-872e-1234567db123";}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackId() {
        return software.amazon.jsii.Kernel.get(this, "stackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The concrete CloudFormation physical stack name.
     * <p>
     * This is either the name defined explicitly in the <code>stackName</code> prop or
     * allocated based on the stack's location in the construct tree. Stacks that
     * are directly defined under the app use their construct <code>id</code> as their stack
     * name. Stacks that are defined deeper within the tree will use a hashed naming
     * scheme based on the construct path to ensure uniqueness.
     * <p>
     * If you wish to obtain the deploy-time AWS::StackName intrinsic,
     * you can use <code>Aws.stackName</code> directly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackName() {
        return software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Synthesis method for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStackSynthesizer getSynthesizer() {
        return software.amazon.jsii.Kernel.get(this, "synthesizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IStackSynthesizer.class));
    }

    /**
     * Tags to be applied to the stack.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The name of the CloudFormation template file emitted to the output directory during synthesis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * "MyStack.template.json";}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile() {
        return software.amazon.jsii.Kernel.get(this, "templateFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Options for CloudFormation template (like version, transform, description).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ITemplateOptions getTemplateOptions() {
        return software.amazon.jsii.Kernel.get(this, "templateOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ITemplateOptions.class));
    }

    /**
     * The Amazon domain suffix for the region in which this stack is defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUrlSuffix() {
        return software.amazon.jsii.Kernel.get(this, "urlSuffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If this is a nested stack, returns it's parent stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Stack getNestedStackParent() {
        return software.amazon.jsii.Kernel.get(this, "nestedStackParent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
    }

    /**
     * If this is a nested stack, this represents its `AWS::CloudFormation::Stack` resource.
     * <p>
     * <code>undefined</code> for top-level (non-nested) stacks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnResource getNestedStackResource() {
        return software.amazon.jsii.Kernel.get(this, "nestedStackResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnResource.class));
    }

    /**
     * (deprecated) Returns the parent of a nested stack.
     * <p>
     * @deprecated use `nestedStackParent`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Stack getParentStack() {
        return software.amazon.jsii.Kernel.get(this, "parentStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
    }

    /**
     * Whether termination protection is enabled for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminationProtection() {
        return software.amazon.jsii.Kernel.get(this, "terminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.Stack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.Stack> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Parent of this stack, usually an `App` or a `Stage`, but could be any construct.
         * @param id The construct ID of this stack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Parent of this stack, usually an `App` or a `Stage`, but could be any construct.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope) {
            return new Builder(scope, null);
        }
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder(null, null);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.core.StackProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Include runtime versioning information in this Stack.
         * <p>
         * Default: `analyticsReporting` setting of containing `App`, or value of
         * 'aws:cdk:version-reporting' context key
         * <p>
         * @return {@code this}
         * @param analyticsReporting Include runtime versioning information in this Stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsReporting(final java.lang.Boolean analyticsReporting) {
            this.props().analyticsReporting(analyticsReporting);
            return this;
        }

        /**
         * A description of the stack.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The AWS environment (account/region) where this stack will be deployed.
         * <p>
         * Set the <code>region</code>/<code>account</code> fields of <code>env</code> to either a concrete value to
         * select the indicated environment (recommended for production stacks), or to
         * the values of environment variables
         * <code>CDK_DEFAULT_REGION</code>/<code>CDK_DEFAULT_ACCOUNT</code> to let the target environment
         * depend on the AWS credentials/configuration that the CDK CLI is executed
         * under (recommended for development stacks).
         * <p>
         * If the <code>Stack</code> is instantiated inside a <code>Stage</code>, any undefined
         * <code>region</code>/<code>account</code> fields from <code>env</code> will default to the same field on the
         * encompassing <code>Stage</code>, if configured there.
         * <p>
         * If either <code>region</code> or <code>account</code> are not set nor inherited from <code>Stage</code>, the
         * Stack will be considered "<em>environment-agnostic</em>"". Environment-agnostic
         * stacks can be deployed to any environment but may not be able to take
         * advantage of all features of the CDK. For example, they will not be able to
         * use environmental context lookups such as <code>ec2.Vpc.fromLookup</code> and will not
         * automatically translate Service Principals to the right format based on the
         * environment's AWS partition, and other such enhancements.
         * <p>
         * Default: - The environment of the containing `Stage` if available,
         * otherwise create the stack will be environment-agnostic.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated. See https://github.com/aws/jsii/issues/826
         * // Use a concrete account and region to deploy this stack to:
         * // `.account` and `.region` will simply return these values.
         * // Use a concrete account and region to deploy this stack to:
         * // `.account` and `.region` will simply return these values.
         * new Stack(app, "Stack1", new StackProps()
         *         .env(new Environment()
         *                 .account("123456789012")
         *                 .region("us-east-1")));
         * // Use the CLI's current credentials to determine the target environment:
         * // `.account` and `.region` will reflect the account+region the CLI
         * // is configured to use (based on the user CLI credentials)
         * // Use the CLI's current credentials to determine the target environment:
         * // `.account` and `.region` will reflect the account+region the CLI
         * // is configured to use (based on the user CLI credentials)
         * new Stack(app, "Stack2", new StackProps()
         *         .env(new Environment()
         *                 .account(process.env.getCDK_DEFAULT_ACCOUNT())
         *                 .region(process.env.getCDK_DEFAULT_REGION())));
         * // Define multiple stacks stage associated with an environment
         * Stage myStage = new Stage(app, "MyStage", new StageProps()
         *         .env(new Environment()
         *                 .account("123456789012")
         *                 .region("us-east-1")));
         * // both of these stacks will use the stage's account/region:
         * // `.account` and `.region` will resolve to the concrete values as above
         * // both of these stacks will use the stage's account/region:
         * // `.account` and `.region` will resolve to the concrete values as above
         * new MyStack(myStage, "Stack1");
         * new YourStack(myStage, "Stack2");
         * // Define an environment-agnostic stack:
         * // `.account` and `.region` will resolve to `{ "Ref": "AWS::AccountId" }` and `{ "Ref": "AWS::Region" }` respectively.
         * // which will only resolve to actual values by CloudFormation during deployment.
         * // Define an environment-agnostic stack:
         * // `.account` and `.region` will resolve to `{ "Ref": "AWS::AccountId" }` and `{ "Ref": "AWS::Region" }` respectively.
         * // which will only resolve to actual values by CloudFormation during deployment.
         * new MyStack(app, "Stack1");}</pre></blockquote>
         * <p>
         * @return {@code this}
         * @param env The AWS environment (account/region) where this stack will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(final software.amazon.awscdk.core.Environment env) {
            this.props().env(env);
            return this;
        }

        /**
         * Name to deploy the stack with.
         * <p>
         * Default: - Derived from construct path.
         * <p>
         * @return {@code this}
         * @param stackName Name to deploy the stack with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(final java.lang.String stackName) {
            this.props().stackName(stackName);
            return this;
        }

        /**
         * Synthesis method to use while deploying this stack.
         * <p>
         * Default: - `DefaultStackSynthesizer` if the `@aws-cdk/core:newStyleStackSynthesis` feature flag
         * is set, `LegacyStackSynthesizer` otherwise.
         * <p>
         * @return {@code this}
         * @param synthesizer Synthesis method to use while deploying this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synthesizer(final software.amazon.awscdk.core.IStackSynthesizer synthesizer) {
            this.props().synthesizer(synthesizer);
            return this;
        }

        /**
         * Stack tags that will be applied to all the taggable resources and the stack itself.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param tags Stack tags that will be applied to all the taggable resources and the stack itself. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Whether to enable termination protection for this stack.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param terminationProtection Whether to enable termination protection for this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtection(final java.lang.Boolean terminationProtection) {
            this.props().terminationProtection(terminationProtection);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.Stack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.Stack build() {
            return new software.amazon.awscdk.core.Stack(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.StackProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.StackProps.Builder();
            }
            return this.props;
        }
    }
}
