package software.amazon.awscdk.core;

/**
 * A Docker volume.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-24T10:27:58.287Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.DockerVolume")
@software.amazon.jsii.Jsii.Proxy(DockerVolume.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DockerVolume extends software.amazon.jsii.JsiiSerializable {

    /**
     * The path where the file or directory is mounted in the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContainerPath();

    /**
     * The path to the file or directory on the host machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHostPath();

    /**
     * Mount consistency.
     * <p>
     * Only applicable for macOS
     * <p>
     * Default: DockerConsistency.DELEGATED
     * <p>
     * @see https://docs.docker.com/storage/bind-mounts/#configure-mount-consistency-for-macos
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.DockerVolumeConsistency getConsistency() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DockerVolume}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerVolume}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DockerVolume> {
        private java.lang.String containerPath;
        private java.lang.String hostPath;
        private software.amazon.awscdk.core.DockerVolumeConsistency consistency;

        /**
         * Sets the value of {@link DockerVolume#getContainerPath}
         * @param containerPath The path where the file or directory is mounted in the container. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPath(java.lang.String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        /**
         * Sets the value of {@link DockerVolume#getHostPath}
         * @param hostPath The path to the file or directory on the host machine. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostPath(java.lang.String hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        /**
         * Sets the value of {@link DockerVolume#getConsistency}
         * @param consistency Mount consistency.
         *                    Only applicable for macOS
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consistency(software.amazon.awscdk.core.DockerVolumeConsistency consistency) {
            this.consistency = consistency;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerVolume}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DockerVolume build() {
            return new Jsii$Proxy(containerPath, hostPath, consistency);
        }
    }

    /**
     * An implementation for {@link DockerVolume}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerVolume {
        private final java.lang.String containerPath;
        private final java.lang.String hostPath;
        private final software.amazon.awscdk.core.DockerVolumeConsistency consistency;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostPath = software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.consistency = software.amazon.jsii.Kernel.get(this, "consistency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerVolumeConsistency.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String containerPath, final java.lang.String hostPath, final software.amazon.awscdk.core.DockerVolumeConsistency consistency) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerPath = java.util.Objects.requireNonNull(containerPath, "containerPath is required");
            this.hostPath = java.util.Objects.requireNonNull(hostPath, "hostPath is required");
            this.consistency = consistency;
        }

        @Override
        public final java.lang.String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final java.lang.String getHostPath() {
            return this.hostPath;
        }

        @Override
        public final software.amazon.awscdk.core.DockerVolumeConsistency getConsistency() {
            return this.consistency;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerPath", om.valueToTree(this.getContainerPath()));
            data.set("hostPath", om.valueToTree(this.getHostPath()));
            if (this.getConsistency() != null) {
                data.set("consistency", om.valueToTree(this.getConsistency()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.DockerVolume"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerVolume.Jsii$Proxy that = (DockerVolume.Jsii$Proxy) o;

            if (!containerPath.equals(that.containerPath)) return false;
            if (!hostPath.equals(that.hostPath)) return false;
            return this.consistency != null ? this.consistency.equals(that.consistency) : that.consistency == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerPath.hashCode();
            result = 31 * result + (this.hostPath.hashCode());
            result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
            return result;
        }
    }
}
