package software.amazon.awscdk.core;

/**
 * Construction properties for {@link Resource}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.1 (build f4a0dbe)", date = "2019-10-02T18:14:53.817Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The value passed in by users to the physical name prop of the resource.
     * 
     * - `undefined` implies that a physical name will be allocated by
     *    CloudFormation during deployment.
     * - a concrete value implies a specific physical name
     * - `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
     *    by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.
     * 
     * Default: - The physical name will be allocated by CloudFormation at deployment time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPhysicalName();

    /**
     * @return a {@link Builder} of {@link ResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String physicalName;

        /**
         * Sets the value of PhysicalName
         * @param physicalName The value passed in by users to the physical name prop of the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalName(java.lang.String physicalName) {
            this.physicalName = physicalName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ResourceProps build() {
            return new Jsii$Proxy(physicalName);
        }
    }

    /**
     * An implementation for {@link ResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceProps {
        private final java.lang.String physicalName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.physicalName = this.jsiiGet("physicalName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String physicalName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.physicalName = physicalName;
        }

        @Override
        public java.lang.String getPhysicalName() {
            return this.physicalName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getPhysicalName() != null) {
                obj.set("physicalName", om.valueToTree(this.getPhysicalName()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceProps.Jsii$Proxy that = (ResourceProps.Jsii$Proxy) o;

            return this.physicalName != null ? this.physicalName.equals(that.physicalName) : that.physicalName == null;
        }

        @Override
        public int hashCode() {
            int result = this.physicalName != null ? this.physicalName.hashCode() : 0;
            return result;
        }
    }
}
