package software.amazon.awscdk.core;

/**
 * Associate the CreationPolicy attribute with a resource to prevent its status from reaching create complete until AWS CloudFormation receives a specified number of success signals or the timeout period is exceeded.
 * <p>
 * To signal a
 * resource, you can use the cfn-signal helper script or SignalResource API. AWS CloudFormation publishes valid signals
 * to the stack events so that you track the number of signals sent.
 * <p>
 * The creation policy is invoked only when AWS CloudFormation creates the associated resource. Currently, the only
 * AWS CloudFormation resources that support creation policies are AWS::AutoScaling::AutoScalingGroup, AWS::EC2::Instance,
 * and AWS::CloudFormation::WaitCondition.
 * <p>
 * Use the CreationPolicy attribute when you want to wait on resource configuration actions before stack creation proceeds.
 * For example, if you install and configure software applications on an EC2 instance, you might want those applications to
 * be running before proceeding. In such cases, you can add a CreationPolicy attribute to the instance, and then send a success
 * signal to the instance after the applications are installed and configured. For a detailed example, see Deploying Applications
 * on Amazon EC2 with AWS CloudFormation.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-17T00:22:54.059Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnCreationPolicy")
@software.amazon.jsii.Jsii.Proxy(CfnCreationPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCreationPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * For an Auto Scaling group replacement update, specifies how many instances must signal success for the update to succeed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy getAutoScalingCreationPolicy() {
        return null;
    }

    /**
     * When AWS CloudFormation creates the associated resource, configures the number of required success signals and the length of time that AWS CloudFormation waits for those signals.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnResourceSignal getResourceSignal() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCreationPolicy> {
        private software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy autoScalingCreationPolicy;
        private software.amazon.awscdk.core.CfnResourceSignal resourceSignal;

        /**
         * Sets the value of {@link CfnCreationPolicy#getAutoScalingCreationPolicy}
         * @param autoScalingCreationPolicy For an Auto Scaling group replacement update, specifies how many instances must signal success for the update to succeed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingCreationPolicy(software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy autoScalingCreationPolicy) {
            this.autoScalingCreationPolicy = autoScalingCreationPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnCreationPolicy#getResourceSignal}
         * @param resourceSignal When AWS CloudFormation creates the associated resource, configures the number of required success signals and the length of time that AWS CloudFormation waits for those signals.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignal(software.amazon.awscdk.core.CfnResourceSignal resourceSignal) {
            this.resourceSignal = resourceSignal;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCreationPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCreationPolicy build() {
            return new Jsii$Proxy(autoScalingCreationPolicy, resourceSignal);
        }
    }

    /**
     * An implementation for {@link CfnCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCreationPolicy {
        private final software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy autoScalingCreationPolicy;
        private final software.amazon.awscdk.core.CfnResourceSignal resourceSignal;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingCreationPolicy = software.amazon.jsii.Kernel.get(this, "autoScalingCreationPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy.class));
            this.resourceSignal = software.amazon.jsii.Kernel.get(this, "resourceSignal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnResourceSignal.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy autoScalingCreationPolicy, final software.amazon.awscdk.core.CfnResourceSignal resourceSignal) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingCreationPolicy = autoScalingCreationPolicy;
            this.resourceSignal = resourceSignal;
        }

        @Override
        public final software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy getAutoScalingCreationPolicy() {
            return this.autoScalingCreationPolicy;
        }

        @Override
        public final software.amazon.awscdk.core.CfnResourceSignal getResourceSignal() {
            return this.resourceSignal;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutoScalingCreationPolicy() != null) {
                data.set("autoScalingCreationPolicy", om.valueToTree(this.getAutoScalingCreationPolicy()));
            }
            if (this.getResourceSignal() != null) {
                data.set("resourceSignal", om.valueToTree(this.getResourceSignal()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CfnCreationPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCreationPolicy.Jsii$Proxy that = (CfnCreationPolicy.Jsii$Proxy) o;

            if (this.autoScalingCreationPolicy != null ? !this.autoScalingCreationPolicy.equals(that.autoScalingCreationPolicy) : that.autoScalingCreationPolicy != null) return false;
            return this.resourceSignal != null ? this.resourceSignal.equals(that.resourceSignal) : that.resourceSignal == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingCreationPolicy != null ? this.autoScalingCreationPolicy.hashCode() : 0;
            result = 31 * result + (this.resourceSignal != null ? this.resourceSignal.hashCode() : 0);
            return result;
        }
    }
}
