package software.amazon.awscdk.core;

/**
 * Determines the ignore behavior to use.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-11T15:14:18.875Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.IgnoreMode")
public enum IgnoreMode {
    /**
     * Ignores file paths based on simple glob patterns.
     * <p>
     * This is the default for file assets.
     * <p>
     * It is also the default for Docker image assets, unless the '&#64;aws-cdk/aws-ecr-assets:dockerIgnoreSupport'
     * context flag is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GLOB,
    /**
     * Ignores file paths based on the [`.gitignore specification`](https://git-scm.com/docs/gitignore).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GIT,
    /**
     * Ignores file paths based on the [`.dockerignore specification`](https://docs.docker.com/engine/reference/builder/#dockerignore-file).
     * <p>
     * This is the default for Docker image assets if the '&#64;aws-cdk/aws-ecr-assets:dockerIgnoreSupport'
     * context flag is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DOCKER,
}
