package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T17:52:23.912Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.StackProps")
@software.amazon.jsii.Jsii.Proxy(StackProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StackProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Include runtime versioning information in this Stack.
     * <p>
     * Default: `analyticsReporting` setting of containing `App`, or value of
     * 'aws:cdk:version-reporting' context key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAnalyticsReporting() {
        return null;
    }

    /**
     * A description of the stack.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The AWS environment (account/region) where this stack will be deployed.
     * <p>
     * Set the <code>region</code>/<code>account</code> fields of <code>env</code> to either a concrete value to
     * select the indicated environment (recommended for production stacks), or to
     * the values of environment variables
     * <code>CDK_DEFAULT_REGION</code>/<code>CDK_DEFAULT_ACCOUNT</code> to let the target environment
     * depend on the AWS credentials/configuration that the CDK CLI is executed
     * under (recommended for development stacks).
     * <p>
     * If the <code>Stack</code> is instantiated inside a <code>Stage</code>, any undefined
     * <code>region</code>/<code>account</code> fields from <code>env</code> will default to the same field on the
     * encompassing <code>Stage</code>, if configured there.
     * <p>
     * If either <code>region</code> or <code>account</code> are not set nor inherited from <code>Stage</code>, the
     * Stack will be considered "<em>environment-agnostic</em>"". Environment-agnostic
     * stacks can be deployed to any environment but may not be able to take
     * advantage of all features of the CDK. For example, they will not be able to
     * use environmental context lookups such as <code>ec2.Vpc.fromLookup</code> and will not
     * automatically translate Service Principals to the right format based on the
     * environment's AWS partition, and other such enhancements.
     * <p>
     * Default: - The environment of the containing `Stage` if available,
     * otherwise create the stack will be environment-agnostic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated. See https://github.com/aws/jsii/issues/826
     * // Use a concrete account and region to deploy this stack to:
     * // `.account` and `.region` will simply return these values.
     * // Use a concrete account and region to deploy this stack to:
     * // `.account` and `.region` will simply return these values.
     * new Stack(app, "Stack1", new StackProps()
     *         .env(new Environment()
     *                 .account("123456789012")
     *                 .region("us-east-1")));
     * // Use the CLI's current credentials to determine the target environment:
     * // `.account` and `.region` will reflect the account+region the CLI
     * // is configured to use (based on the user CLI credentials)
     * // Use the CLI's current credentials to determine the target environment:
     * // `.account` and `.region` will reflect the account+region the CLI
     * // is configured to use (based on the user CLI credentials)
     * new Stack(app, "Stack2", new StackProps()
     *         .env(new Environment()
     *                 .account(process.env.getCDK_DEFAULT_ACCOUNT())
     *                 .region(process.env.getCDK_DEFAULT_REGION())));
     * // Define multiple stacks stage associated with an environment
     * Stage myStage = new Stage(app, "MyStage", new StageProps()
     *         .env(new Environment()
     *                 .account("123456789012")
     *                 .region("us-east-1")));
     * // both of these stacks will use the stage's account/region:
     * // `.account` and `.region` will resolve to the concrete values as above
     * // both of these stacks will use the stage's account/region:
     * // `.account` and `.region` will resolve to the concrete values as above
     * new MyStack(myStage, "Stack1");
     * new YourStack(myStage, "Stack2");
     * // Define an environment-agnostic stack:
     * // `.account` and `.region` will resolve to `{ "Ref": "AWS::AccountId" }` and `{ "Ref": "AWS::Region" }` respectively.
     * // which will only resolve to actual values by CloudFormation during deployment.
     * // Define an environment-agnostic stack:
     * // `.account` and `.region` will resolve to `{ "Ref": "AWS::AccountId" }` and `{ "Ref": "AWS::Region" }` respectively.
     * // which will only resolve to actual values by CloudFormation during deployment.
     * new MyStack(app, "Stack1");}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Environment getEnv() {
        return null;
    }

    /**
     * Name to deploy the stack with.
     * <p>
     * Default: - Derived from construct path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStackName() {
        return null;
    }

    /**
     * Synthesis method to use while deploying this stack.
     * <p>
     * Default: - `DefaultStackSynthesizer` if the `@aws-cdk/core:newStyleStackSynthesis` feature flag
     * is set, `LegacyStackSynthesizer` otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IStackSynthesizer getSynthesizer() {
        return null;
    }

    /**
     * Stack tags that will be applied to all the taggable resources and the stack itself.
     * <p>
     * Default: {}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * Whether to enable termination protection for this stack.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminationProtection() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StackProps> {
        private java.lang.Boolean analyticsReporting;
        private java.lang.String description;
        private software.amazon.awscdk.core.Environment env;
        private java.lang.String stackName;
        private software.amazon.awscdk.core.IStackSynthesizer synthesizer;
        private java.util.Map<java.lang.String, java.lang.String> tags;
        private java.lang.Boolean terminationProtection;

        /**
         * Sets the value of {@link StackProps#getAnalyticsReporting}
         * @param analyticsReporting Include runtime versioning information in this Stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsReporting(java.lang.Boolean analyticsReporting) {
            this.analyticsReporting = analyticsReporting;
            return this;
        }

        /**
         * Sets the value of {@link StackProps#getDescription}
         * @param description A description of the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link StackProps#getEnv}
         * @param env The AWS environment (account/region) where this stack will be deployed.
         *            Set the <code>region</code>/<code>account</code> fields of <code>env</code> to either a concrete value to
         *            select the indicated environment (recommended for production stacks), or to
         *            the values of environment variables
         *            <code>CDK_DEFAULT_REGION</code>/<code>CDK_DEFAULT_ACCOUNT</code> to let the target environment
         *            depend on the AWS credentials/configuration that the CDK CLI is executed
         *            under (recommended for development stacks).
         *            <p>
         *            If the <code>Stack</code> is instantiated inside a <code>Stage</code>, any undefined
         *            <code>region</code>/<code>account</code> fields from <code>env</code> will default to the same field on the
         *            encompassing <code>Stage</code>, if configured there.
         *            <p>
         *            If either <code>region</code> or <code>account</code> are not set nor inherited from <code>Stage</code>, the
         *            Stack will be considered "<em>environment-agnostic</em>"". Environment-agnostic
         *            stacks can be deployed to any environment but may not be able to take
         *            advantage of all features of the CDK. For example, they will not be able to
         *            use environmental context lookups such as <code>ec2.Vpc.fromLookup</code> and will not
         *            automatically translate Service Principals to the right format based on the
         *            environment's AWS partition, and other such enhancements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(software.amazon.awscdk.core.Environment env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link StackProps#getStackName}
         * @param stackName Name to deploy the stack with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Sets the value of {@link StackProps#getSynthesizer}
         * @param synthesizer Synthesis method to use while deploying this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synthesizer(software.amazon.awscdk.core.IStackSynthesizer synthesizer) {
            this.synthesizer = synthesizer;
            return this;
        }

        /**
         * Sets the value of {@link StackProps#getTags}
         * @param tags Stack tags that will be applied to all the taggable resources and the stack itself.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link StackProps#getTerminationProtection}
         * @param terminationProtection Whether to enable termination protection for this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtection(java.lang.Boolean terminationProtection) {
            this.terminationProtection = terminationProtection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StackProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StackProps build() {
            return new Jsii$Proxy(analyticsReporting, description, env, stackName, synthesizer, tags, terminationProtection);
        }
    }

    /**
     * An implementation for {@link StackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackProps {
        private final java.lang.Boolean analyticsReporting;
        private final java.lang.String description;
        private final software.amazon.awscdk.core.Environment env;
        private final java.lang.String stackName;
        private final software.amazon.awscdk.core.IStackSynthesizer synthesizer;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Boolean terminationProtection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.analyticsReporting = software.amazon.jsii.Kernel.get(this, "analyticsReporting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Environment.class));
            this.stackName = software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.synthesizer = software.amazon.jsii.Kernel.get(this, "synthesizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IStackSynthesizer.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.terminationProtection = software.amazon.jsii.Kernel.get(this, "terminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Boolean analyticsReporting, final java.lang.String description, final software.amazon.awscdk.core.Environment env, final java.lang.String stackName, final software.amazon.awscdk.core.IStackSynthesizer synthesizer, final java.util.Map<java.lang.String, java.lang.String> tags, final java.lang.Boolean terminationProtection) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.analyticsReporting = analyticsReporting;
            this.description = description;
            this.env = env;
            this.stackName = stackName;
            this.synthesizer = synthesizer;
            this.tags = tags;
            this.terminationProtection = terminationProtection;
        }

        @Override
        public final java.lang.Boolean getAnalyticsReporting() {
            return this.analyticsReporting;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.core.Environment getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        public final software.amazon.awscdk.core.IStackSynthesizer getSynthesizer() {
            return this.synthesizer;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Boolean getTerminationProtection() {
            return this.terminationProtection;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAnalyticsReporting() != null) {
                data.set("analyticsReporting", om.valueToTree(this.getAnalyticsReporting()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getStackName() != null) {
                data.set("stackName", om.valueToTree(this.getStackName()));
            }
            if (this.getSynthesizer() != null) {
                data.set("synthesizer", om.valueToTree(this.getSynthesizer()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTerminationProtection() != null) {
                data.set("terminationProtection", om.valueToTree(this.getTerminationProtection()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.StackProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StackProps.Jsii$Proxy that = (StackProps.Jsii$Proxy) o;

            if (this.analyticsReporting != null ? !this.analyticsReporting.equals(that.analyticsReporting) : that.analyticsReporting != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.stackName != null ? !this.stackName.equals(that.stackName) : that.stackName != null) return false;
            if (this.synthesizer != null ? !this.synthesizer.equals(that.synthesizer) : that.synthesizer != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.terminationProtection != null ? this.terminationProtection.equals(that.terminationProtection) : that.terminationProtection == null;
        }

        @Override
        public final int hashCode() {
            int result = this.analyticsReporting != null ? this.analyticsReporting.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.stackName != null ? this.stackName.hashCode() : 0);
            result = 31 * result + (this.synthesizer != null ? this.synthesizer.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.terminationProtection != null ? this.terminationProtection.hashCode() : 0);
            return result;
        }
    }
}
