package software.amazon.awscdk.core;

/**
 * Uses conventionally named roles and reify asset storage locations.
 * <p>
 * This synthesizer is the only StackSynthesizer that generates
 * an asset manifest, and is required to deploy CDK applications using the
 * <code>&#64;aws-cdk/app-delivery</code> CI/CD library.
 * <p>
 * Requires the environment to have been bootstrapped with Bootstrap Stack V2.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T17:52:20.085Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.DefaultStackSynthesizer")
public class DefaultStackSynthesizer extends software.amazon.awscdk.core.StackSynthesizer {

    protected DefaultStackSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DefaultStackSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_CLOUDFORMATION_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.DefaultStackSynthesizer.class, "DEFAULT_CLOUDFORMATION_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_DEPLOY_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.DefaultStackSynthesizer.class, "DEFAULT_DEPLOY_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSET_PREFIX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSET_PREFIX", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSETS_BUCKET_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSETS_BUCKET_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.DefaultStackSynthesizer.class, "DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.DefaultStackSynthesizer.class, "DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_QUALIFIER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.DefaultStackSynthesizer.class, "DEFAULT_QUALIFIER", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DefaultStackSynthesizer(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.DefaultStackSynthesizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DefaultStackSynthesizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Bind to the stack this environment is going to be used on.
     * <p>
     * Must be called before any of the other methods are called.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack stack) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Synthesize the associated stack to the session.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Default CloudFormation role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_CLOUDFORMATION_ROLE_ARN;

    /**
     * Default deploy role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_DEPLOY_ROLE_ARN;

    /**
     * Name of the CloudFormation Export with the asset key name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME;

    /**
     * Default file asset prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_FILE_ASSET_PREFIX;

    /**
     * Default asset publishing role ARN for file (S3) assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN;

    /**
     * Default file assets bucket name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_FILE_ASSETS_BUCKET_NAME;

    /**
     * Default asset publishing role ARN for image (ECR) assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN;

    /**
     * Default image assets repository name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME;

    /**
     * Default ARN qualifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_QUALIFIER;

    /**
     * Returns the ARN of the CFN execution Role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCloudFormationExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "cloudFormationExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the ARN of the deploy Role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeployRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "deployRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Stack getStack() {
        return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.DefaultStackSynthesizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.DefaultStackSynthesizer> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.core.DefaultStackSynthesizerProps.Builder props;

        private Builder() {
        }

        /**
         * bucketPrefix to use while storing S3 Assets.
         * <p>
         * Default: - DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX
         * <p>
         * @return {@code this}
         * @param bucketPrefix bucketPrefix to use while storing S3 Assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketPrefix(final java.lang.String bucketPrefix) {
            this.props().bucketPrefix(bucketPrefix);
            return this;
        }

        /**
         * The role CloudFormation will assume when deploying the Stack.
         * <p>
         * You must supply this if you have given a non-standard name to the execution role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param cloudFormationExecutionRole The role CloudFormation will assume when deploying the Stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRole(final java.lang.String cloudFormationExecutionRole) {
            this.props().cloudFormationExecutionRole(cloudFormationExecutionRole);
            return this;
        }

        /**
         * The role to assume to initiate a deployment in this environment.
         * <p>
         * You must supply this if you have given a non-standard name to the publishing role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param deployRoleArn The role to assume to initiate a deployment in this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleArn(final java.lang.String deployRoleArn) {
            this.props().deployRoleArn(deployRoleArn);
            return this;
        }

        /**
         * (deprecated) Name of the CloudFormation Export with the asset key name.
         * <p>
         * You must supply this if you have given a non-standard name to the KMS key export
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME
         * <p>
         * @return {@code this}
         * @deprecated This property is not used anymore
         * @param fileAssetKeyArnExportName Name of the CloudFormation Export with the asset key name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder fileAssetKeyArnExportName(final java.lang.String fileAssetKeyArnExportName) {
            this.props().fileAssetKeyArnExportName(fileAssetKeyArnExportName);
            return this;
        }

        /**
         * External ID to use when assuming role for file asset publishing.
         * <p>
         * Default: - No external ID
         * <p>
         * @return {@code this}
         * @param fileAssetPublishingExternalId External ID to use when assuming role for file asset publishing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetPublishingExternalId(final java.lang.String fileAssetPublishingExternalId) {
            this.props().fileAssetPublishingExternalId(fileAssetPublishingExternalId);
            return this;
        }

        /**
         * The role to use to publish file assets to the S3 bucket in this environment.
         * <p>
         * You must supply this if you have given a non-standard name to the publishing role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param fileAssetPublishingRoleArn The role to use to publish file assets to the S3 bucket in this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetPublishingRoleArn(final java.lang.String fileAssetPublishingRoleArn) {
            this.props().fileAssetPublishingRoleArn(fileAssetPublishingRoleArn);
            return this;
        }

        /**
         * Name of the S3 bucket to hold file assets.
         * <p>
         * You must supply this if you have given a non-standard name to the staging bucket.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME
         * <p>
         * @return {@code this}
         * @param fileAssetsBucketName Name of the S3 bucket to hold file assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetsBucketName(final java.lang.String fileAssetsBucketName) {
            this.props().fileAssetsBucketName(fileAssetsBucketName);
            return this;
        }

        /**
         * Whether to add a Rule to the stack template verifying the bootstrap stack version.
         * <p>
         * This generally should be left set to <code>true</code>, unless you explicitly
         * want to be able to deploy to an unbootstrapped environment.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param generateBootstrapVersionRule Whether to add a Rule to the stack template verifying the bootstrap stack version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateBootstrapVersionRule(final java.lang.Boolean generateBootstrapVersionRule) {
            this.props().generateBootstrapVersionRule(generateBootstrapVersionRule);
            return this;
        }

        /**
         * External ID to use when assuming role for image asset publishing.
         * <p>
         * Default: - No external ID
         * <p>
         * @return {@code this}
         * @param imageAssetPublishingExternalId External ID to use when assuming role for image asset publishing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetPublishingExternalId(final java.lang.String imageAssetPublishingExternalId) {
            this.props().imageAssetPublishingExternalId(imageAssetPublishingExternalId);
            return this;
        }

        /**
         * The role to use to publish image assets to the ECR repository in this environment.
         * <p>
         * You must supply this if you have given a non-standard name to the publishing role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param imageAssetPublishingRoleArn The role to use to publish image assets to the ECR repository in this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetPublishingRoleArn(final java.lang.String imageAssetPublishingRoleArn) {
            this.props().imageAssetPublishingRoleArn(imageAssetPublishingRoleArn);
            return this;
        }

        /**
         * Name of the ECR repository to hold Docker Image assets.
         * <p>
         * You must supply this if you have given a non-standard name to the ECR repository.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME
         * <p>
         * @return {@code this}
         * @param imageAssetsRepositoryName Name of the ECR repository to hold Docker Image assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetsRepositoryName(final java.lang.String imageAssetsRepositoryName) {
            this.props().imageAssetsRepositoryName(imageAssetsRepositoryName);
            return this;
        }

        /**
         * Qualifier to disambiguate multiple environments in the same account.
         * <p>
         * You can use this and leave the other naming properties empty if you have deployed
         * the bootstrap environment with standard names but only differnet qualifiers.
         * <p>
         * Default: - Value of context key '
         * <p>
         * @return {@code this}
         * @param qualifier Qualifier to disambiguate multiple environments in the same account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(final java.lang.String qualifier) {
            this.props().qualifier(qualifier);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.DefaultStackSynthesizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.DefaultStackSynthesizer build() {
            return new software.amazon.awscdk.core.DefaultStackSynthesizer(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.DefaultStackSynthesizerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.DefaultStackSynthesizerProps.Builder();
            }
            return this.props;
        }
    }
}
