package software.amazon.awscdk.core;

/**
 * Represents a length of time.
 * <p>
 * The amount can be specified either as a literal value (e.g: <code>10</code>) which
 * cannot be negative, or as an unresolved number token.
 * <p>
 * When the amount is passed as a token, unit conversion is not possible.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-19T10:17:55.466Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Duration")
public class Duration extends software.amazon.jsii.JsiiObject {

    protected Duration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Duration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a Duration representing an amount of days.
     * <p>
     * @return a new `Duration` representing `amount` Days.
     * @param amount the amount of Days the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration days(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "days", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Duration representing an amount of hours.
     * <p>
     * @return a new `Duration` representing `amount` Hours.
     * @param amount the amount of Hours the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration hours(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "hours", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Duration representing an amount of milliseconds.
     * <p>
     * @return a new `Duration` representing `amount` ms.
     * @param amount the amount of Milliseconds the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration millis(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "millis", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Duration representing an amount of minutes.
     * <p>
     * @return a new `Duration` representing `amount` Minutes.
     * @param amount the amount of Minutes the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration minutes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "minutes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Parse a period formatted according to the ISO 8601 standard.
     * <p>
     * @return the parsed `Duration`.
     * @see https://www.iso.org/fr/standard/70907.html
     * @param duration an ISO-formtted duration to be parsed. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration parse(final @org.jetbrains.annotations.NotNull java.lang.String duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "parse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * Create a Duration representing an amount of seconds.
     * <p>
     * @return a new `Duration` representing `amount` Seconds.
     * @param amount the amount of Seconds the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration seconds(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "seconds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Returns stringified number of duration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String formatTokenToNumber() {
        return software.amazon.jsii.Kernel.call(this, "formatTokenToNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Checks if duration is a token or a resolvable object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isUnresolved() {
        return software.amazon.jsii.Kernel.call(this, "isUnresolved", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Add two Durations together.
     * <p>
     * @param rhs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration plus(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration rhs) {
        return software.amazon.jsii.Kernel.call(this, "plus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class), new Object[] { java.util.Objects.requireNonNull(rhs, "rhs is required") });
    }

    /**
     * Return the total number of days in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Days.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toDays(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TimeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return the total number of days in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toDays() {
        return software.amazon.jsii.Kernel.call(this, "toDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return the total number of hours in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Hours.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toHours(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TimeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return the total number of hours in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toHours() {
        return software.amazon.jsii.Kernel.call(this, "toHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Turn this duration into a human-readable string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toHumanString() {
        return software.amazon.jsii.Kernel.call(this, "toHumanString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return an ISO 8601 representation of this period.
     * <p>
     * @return a string starting with 'P' describing the period
     * @see https://www.iso.org/fr/standard/70907.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toIsoString() {
        return software.amazon.jsii.Kernel.call(this, "toIsoString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) Return an ISO 8601 representation of this period.
     * <p>
     * @return a string starting with 'P' describing the period
     * @see https://www.iso.org/fr/standard/70907.html
     * @deprecated Use `toIsoString()` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String toISOString() {
        return software.amazon.jsii.Kernel.call(this, "toISOString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the total number of milliseconds in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Milliseconds.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMilliseconds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TimeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return the total number of milliseconds in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Milliseconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMilliseconds() {
        return software.amazon.jsii.Kernel.call(this, "toMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return the total number of minutes in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Minutes.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMinutes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TimeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return the total number of minutes in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMinutes() {
        return software.amazon.jsii.Kernel.call(this, "toMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return the total number of seconds in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Seconds.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toSeconds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TimeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return the total number of seconds in this Duration.
     * <p>
     * @return the value of this `Duration` expressed in Seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toSeconds() {
        return software.amazon.jsii.Kernel.call(this, "toSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Returns a string representation of this `Duration` that is also a Token that cannot be successfully resolved.
     * <p>
     * This
     * protects users against inadvertently stringifying a <code>Duration</code> object, when they should have called one of the
     * <code>to*</code> methods instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns unit of the duration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String unitLabel() {
        return software.amazon.jsii.Kernel.call(this, "unitLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
