package software.amazon.awscdk.core;

/**
 * Features that are implemented behind a flag in order to preserve backwards compatibility for existing apps.
 * <p>
 * The list of flags are available in the
 * <code>&#64;aws-cdk/cx-api</code> module.
 * <p>
 * The state of the flag for this application is stored as a CDK context variable.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:39:37.362Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.FeatureFlags")
public class FeatureFlags extends software.amazon.jsii.JsiiObject {

    protected FeatureFlags(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FeatureFlags(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Inspect feature flags on the construct node's context.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FeatureFlags of(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.FeatureFlags.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.FeatureFlags.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Check whether a feature flag is enabled.
     * <p>
     * If configured, the flag is present in
     * the construct node context. Falls back to the defaults defined in the <code>cx-api</code>
     * module.
     * <p>
     * @param featureFlag This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean isEnabled(final @org.jetbrains.annotations.NotNull java.lang.String featureFlag) {
        return software.amazon.jsii.Kernel.call(this, "isEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(featureFlag, "featureFlag is required") });
    }
}
