package software.amazon.awscdk.core;

/**
 * The traffic routing configuration if {@link CfnTrafficRoutingConfig.type} is {@link CfnTrafficRoutingType.TIME_BASED_CANARY}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:39:36.675Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnTrafficRoutingTimeBasedCanary")
@software.amazon.jsii.Jsii.Proxy(CfnTrafficRoutingTimeBasedCanary.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrafficRoutingTimeBasedCanary extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of minutes between the first and second traffic shifts of a time-based canary deployment.
     * <p>
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBakeTimeMins() {
        return null;
    }

    /**
     * The percentage of traffic to shift in the first increment of a time-based canary deployment.
     * <p>
     * The step percentage must be 14% or greater.
     * <p>
     * Default: 15
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStepPercentage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTrafficRoutingTimeBasedCanary}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrafficRoutingTimeBasedCanary}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrafficRoutingTimeBasedCanary> {
        private java.lang.Number bakeTimeMins;
        private java.lang.Number stepPercentage;

        /**
         * Sets the value of {@link CfnTrafficRoutingTimeBasedCanary#getBakeTimeMins}
         * @param bakeTimeMins The number of minutes between the first and second traffic shifts of a time-based canary deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bakeTimeMins(java.lang.Number bakeTimeMins) {
            this.bakeTimeMins = bakeTimeMins;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficRoutingTimeBasedCanary#getStepPercentage}
         * @param stepPercentage The percentage of traffic to shift in the first increment of a time-based canary deployment.
         *                       The step percentage must be 14% or greater.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepPercentage(java.lang.Number stepPercentage) {
            this.stepPercentage = stepPercentage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrafficRoutingTimeBasedCanary}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrafficRoutingTimeBasedCanary build() {
            return new Jsii$Proxy(bakeTimeMins, stepPercentage);
        }
    }

    /**
     * An implementation for {@link CfnTrafficRoutingTimeBasedCanary}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrafficRoutingTimeBasedCanary {
        private final java.lang.Number bakeTimeMins;
        private final java.lang.Number stepPercentage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bakeTimeMins = software.amazon.jsii.Kernel.get(this, "bakeTimeMins", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.stepPercentage = software.amazon.jsii.Kernel.get(this, "stepPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Number bakeTimeMins, final java.lang.Number stepPercentage) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bakeTimeMins = bakeTimeMins;
            this.stepPercentage = stepPercentage;
        }

        @Override
        public final java.lang.Number getBakeTimeMins() {
            return this.bakeTimeMins;
        }

        @Override
        public final java.lang.Number getStepPercentage() {
            return this.stepPercentage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBakeTimeMins() != null) {
                data.set("bakeTimeMins", om.valueToTree(this.getBakeTimeMins()));
            }
            if (this.getStepPercentage() != null) {
                data.set("stepPercentage", om.valueToTree(this.getStepPercentage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CfnTrafficRoutingTimeBasedCanary"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrafficRoutingTimeBasedCanary.Jsii$Proxy that = (CfnTrafficRoutingTimeBasedCanary.Jsii$Proxy) o;

            if (this.bakeTimeMins != null ? !this.bakeTimeMins.equals(that.bakeTimeMins) : that.bakeTimeMins != null) return false;
            return this.stepPercentage != null ? this.stepPercentage.equals(that.stepPercentage) : that.stepPercentage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bakeTimeMins != null ? this.bakeTimeMins.hashCode() : 0;
            result = 31 * result + (this.stepPercentage != null ? this.stepPercentage.hashCode() : 0);
            return result;
        }
    }
}
