package software.amazon.awscdk.core;

/**
 * Determines how symlinks are followed.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-05-04T12:08:38.044Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.SymlinkFollowMode")
public enum SymlinkFollowMode {
    /**
     * Never follow symlinks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEVER,
    /**
     * Materialize all symlinks, whether they are internal or external to the source directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALWAYS,
    /**
     * Only follows symlinks that are external to the source directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXTERNAL,
    /**
     * Forbids source from having any symlinks pointing outside of the source tree.
     * <p>
     * This is the safest mode of operation as it ensures that copy operations
     * won't materialize files from the user's file system. Internal symlinks are
     * not followed.
     * <p>
     * If the copy operation runs into an external symlink, it will fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BLOCK_EXTERNAL,
}
