package software.amazon.awscdk.core;

/**
 * Trait for IDependable.
 * 
 * Traits are interfaces that are privately implemented by objects. Instead of
 * showing up in the public interface of a class, they need to be queried
 * explicitly. This is used to implement certain framework features that are
 * not intended to be used by Construct consumers, and so should be hidden
 * from accidental use.
 * 
 * Example:
 * 
 * // Usage
 * const roots = DependableTrait.get(construct).dependencyRoots;
 * 
 * // Definition
 * DependableTrait.implement(construct, {
 *   get dependencyRoots() { return []; }
 * });
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-10-01T14:33:48.519Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.DependableTrait")
public abstract class DependableTrait extends software.amazon.jsii.JsiiObject {

    protected DependableTrait(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DependableTrait(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected DependableTrait() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this));
    }

    /**
     * Return the matching DependableTrait for the given class instance.
     * 
     * EXPERIMENTAL
     * 
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.DependableTrait get(final software.amazon.awscdk.core.IDependable instance) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.DependableTrait.class, "get", software.amazon.awscdk.core.DependableTrait.class, new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * Register `instance` to have the given DependableTrait.
     * 
     * Should be called in the class constructor.
     * 
     * EXPERIMENTAL
     * 
     * @param instance This parameter is required.
     * @param trait This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static void implement(final software.amazon.awscdk.core.IDependable instance, final software.amazon.awscdk.core.DependableTrait trait) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.DependableTrait.class, "implement", Void.class, new Object[] { java.util.Objects.requireNonNull(instance, "instance is required"), java.util.Objects.requireNonNull(trait, "trait is required") });
    }

    /**
     * The set of constructs that form the root of this dependable.
     * 
     * All resources under all returned constructs are included in the ordering
     * dependency.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.core.IConstruct> getDependencyRoots() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("dependencyRoots", java.util.List.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.core.DependableTrait {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
        }

        /**
         * The set of constructs that form the root of this dependable.
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.util.List<software.amazon.awscdk.core.IConstruct> getDependencyRoots() {
            return java.util.Collections.unmodifiableList(this.jsiiGet("dependencyRoots", java.util.List.class));
        }
    }
}
