package software.amazon.awscdk.core;

/**
 * With scheduled actions, the group size properties of an Auto Scaling group can change at any time.
 * 
 * When you update a
 * stack with an Auto Scaling group and scheduled action, AWS CloudFormation always sets the group size property values of
 * your Auto Scaling group to the values that are defined in the AWS::AutoScaling::AutoScalingGroup resource of your template,
 * even if a scheduled action is in effect.
 * 
 * If you do not want AWS CloudFormation to change any of the group size property values when you have a scheduled action in
 * effect, use the AutoScalingScheduledAction update policy to prevent AWS CloudFormation from changing the MinSize, MaxSize,
 * or DesiredCapacity properties unless you have modified these values in your template.\
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T18:56:09.864Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAutoScalingScheduledAction extends software.amazon.jsii.JsiiSerializable {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getIgnoreUnmodifiedGroupSizeProperties();

    /**
     * @return a {@link Builder} of {@link CfnAutoScalingScheduledAction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnAutoScalingScheduledAction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _ignoreUnmodifiedGroupSizeProperties;

        /**
         * Sets the value of IgnoreUnmodifiedGroupSizeProperties
         * @param value the value to be set
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withIgnoreUnmodifiedGroupSizeProperties(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._ignoreUnmodifiedGroupSizeProperties = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAutoScalingScheduledAction}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnAutoScalingScheduledAction build() {
            return new CfnAutoScalingScheduledAction() {
                @javax.annotation.Nullable
                private final java.lang.Boolean $ignoreUnmodifiedGroupSizeProperties = _ignoreUnmodifiedGroupSizeProperties;

                @Override
                public java.lang.Boolean getIgnoreUnmodifiedGroupSizeProperties() {
                    return this.$ignoreUnmodifiedGroupSizeProperties;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getIgnoreUnmodifiedGroupSizeProperties() != null) {
                        obj.set("ignoreUnmodifiedGroupSizeProperties", om.valueToTree(this.getIgnoreUnmodifiedGroupSizeProperties()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.CfnAutoScalingScheduledAction {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getIgnoreUnmodifiedGroupSizeProperties() {
            return this.jsiiGet("ignoreUnmodifiedGroupSizeProperties", java.lang.Boolean.class);
        }
    }
}
