package software.amazon.awscdk.core;

/**
 * Properties for a tag.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:18:56.715Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TagProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Whether the tag should be applied to instances in an AutoScalingGroup.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getApplyToLaunchedInstances();
    /**
     * An array of Resource Types that will not receive this tag.
     * 
     * An empty array will allow this tag to be applied to all resources. A
     * non-empty array will apply this tag only if the Resource type is not in
     * this array.
     * 
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getExcludeResourceTypes();
    /**
     * An array of Resource Types that will receive this tag.
     * 
     * An empty array will match any Resource. A non-empty array will apply this
     * tag only to Resource types that are included in this array.
     * 
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getIncludeResourceTypes();
    /**
     * Priority of the tag operation.
     * 
     * Higher or equal priority tags will take precedence.
     * 
     * Setting priority will enable the user to control tags when they need to not
     * follow the default precedence pattern of last applied and closest to the
     * construct in the tree.
     * 
     * Default: Default priorities:
     * 
     * - 100 for {@link SetTag}
     * - 200 for {@link RemoveTag}
     * - 50 for tags added directly to CloudFormation resources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPriority();

    /**
     * @return a {@link Builder} of {@link TagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link TagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _applyToLaunchedInstances;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _excludeResourceTypes;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _includeResourceTypes;
        @javax.annotation.Nullable
        private java.lang.Number _priority;

        /**
         * Sets the value of ApplyToLaunchedInstances
         * @param value Whether the tag should be applied to instances in an AutoScalingGroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withApplyToLaunchedInstances(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._applyToLaunchedInstances = value;
            return this;
        }
        /**
         * Sets the value of ExcludeResourceTypes
         * @param value An array of Resource Types that will not receive this tag.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withExcludeResourceTypes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._excludeResourceTypes = value;
            return this;
        }
        /**
         * Sets the value of IncludeResourceTypes
         * @param value An array of Resource Types that will receive this tag.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withIncludeResourceTypes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._includeResourceTypes = value;
            return this;
        }
        /**
         * Sets the value of Priority
         * @param value Priority of the tag operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPriority(@javax.annotation.Nullable final java.lang.Number value) {
            this._priority = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TagProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public TagProps build() {
            return new TagProps() {
                @javax.annotation.Nullable
                private final java.lang.Boolean $applyToLaunchedInstances = _applyToLaunchedInstances;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $excludeResourceTypes = _excludeResourceTypes;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $includeResourceTypes = _includeResourceTypes;
                @javax.annotation.Nullable
                private final java.lang.Number $priority = _priority;

                @Override
                public java.lang.Boolean getApplyToLaunchedInstances() {
                    return this.$applyToLaunchedInstances;
                }

                @Override
                public java.util.List<java.lang.String> getExcludeResourceTypes() {
                    return this.$excludeResourceTypes;
                }

                @Override
                public java.util.List<java.lang.String> getIncludeResourceTypes() {
                    return this.$includeResourceTypes;
                }

                @Override
                public java.lang.Number getPriority() {
                    return this.$priority;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getApplyToLaunchedInstances() != null) {
                        obj.set("applyToLaunchedInstances", om.valueToTree(this.getApplyToLaunchedInstances()));
                    }
                    if (this.getExcludeResourceTypes() != null) {
                        obj.set("excludeResourceTypes", om.valueToTree(this.getExcludeResourceTypes()));
                    }
                    if (this.getIncludeResourceTypes() != null) {
                        obj.set("includeResourceTypes", om.valueToTree(this.getIncludeResourceTypes()));
                    }
                    if (this.getPriority() != null) {
                        obj.set("priority", om.valueToTree(this.getPriority()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.TagProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Whether the tag should be applied to instances in an AutoScalingGroup.
         * 
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getApplyToLaunchedInstances() {
            return this.jsiiGet("applyToLaunchedInstances", java.lang.Boolean.class);
        }

        /**
         * An array of Resource Types that will not receive this tag.
         * 
         * An empty array will allow this tag to be applied to all resources. A
         * non-empty array will apply this tag only if the Resource type is not in
         * this array.
         * 
         * Default: []
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getExcludeResourceTypes() {
            return this.jsiiGet("excludeResourceTypes", java.util.List.class);
        }

        /**
         * An array of Resource Types that will receive this tag.
         * 
         * An empty array will match any Resource. A non-empty array will apply this
         * tag only to Resource types that are included in this array.
         * 
         * Default: []
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getIncludeResourceTypes() {
            return this.jsiiGet("includeResourceTypes", java.util.List.class);
        }

        /**
         * Priority of the tag operation.
         * 
         * Higher or equal priority tags will take precedence.
         * 
         * Setting priority will enable the user to control tags when they need to not
         * follow the default precedence pattern of last applied and closest to the
         * construct in the tree.
         * 
         * Default: Default priorities:
         * 
         * - 100 for {@link SetTag}
         * - 200 for {@link RemoveTag}
         * - 50 for tags added directly to CloudFormation resources
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getPriority() {
            return this.jsiiGet("priority", java.lang.Number.class);
        }
    }
}
