package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:18:56.713Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StackProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The AWS environment (account/region) where this stack will be deployed.
     * 
     * Default: - The `default-account` and `default-region` context parameters will be
     * used. If they are undefined, it will not be possible to deploy the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Environment getEnv();
    /**
     * Name to deploy the stack with.
     * 
     * Default: - Derived from construct path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getStackName();
    /**
     * Stack tags that will be applied to all the taggable resources and the stack itself.
     * 
     * Default: {}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.String> getTags();

    /**
     * @return a {@link Builder} of {@link StackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Environment _env;
        @javax.annotation.Nullable
        private java.lang.String _stackName;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _tags;

        /**
         * Sets the value of Env
         * @param value The AWS environment (account/region) where this stack will be deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEnv(@javax.annotation.Nullable final software.amazon.awscdk.core.Environment value) {
            this._env = value;
            return this;
        }
        /**
         * Sets the value of StackName
         * @param value Name to deploy the stack with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStackName(@javax.annotation.Nullable final java.lang.String value) {
            this._stackName = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value Stack tags that will be applied to all the taggable resources and the stack itself.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._tags = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StackProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public StackProps build() {
            return new StackProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Environment $env = _env;
                @javax.annotation.Nullable
                private final java.lang.String $stackName = _stackName;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $tags = _tags;

                @Override
                public software.amazon.awscdk.core.Environment getEnv() {
                    return this.$env;
                }

                @Override
                public java.lang.String getStackName() {
                    return this.$stackName;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getTags() {
                    return this.$tags;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getEnv() != null) {
                        obj.set("env", om.valueToTree(this.getEnv()));
                    }
                    if (this.getStackName() != null) {
                        obj.set("stackName", om.valueToTree(this.getStackName()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.StackProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The AWS environment (account/region) where this stack will be deployed.
         * 
         * Default: - The `default-account` and `default-region` context parameters will be
         * used. If they are undefined, it will not be possible to deploy the stack.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Environment getEnv() {
            return this.jsiiGet("env", software.amazon.awscdk.core.Environment.class);
        }

        /**
         * Name to deploy the stack with.
         * 
         * Default: - Derived from construct path.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getStackName() {
            return this.jsiiGet("stackName", java.lang.String.class);
        }

        /**
         * Stack tags that will be applied to all the taggable resources and the stack itself.
         * 
         * Default: {}
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.jsiiGet("tags", java.util.Map.class);
        }
    }
}
