package software.amazon.awscdk.core;

/**
 * For an Auto Scaling group replacement update, specifies how many instances must signal success for the update to succeed.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:18:56.691Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceAutoScalingCreationPolicy extends software.amazon.jsii.JsiiSerializable {
    /**
     * Specifies the percentage of instances in an Auto Scaling replacement update that must signal success for the update to succeed.
     * 
     * You can specify a value from 0 to 100. AWS CloudFormation rounds to the nearest tenth of a percent.
     * For example, if you update five instances with a minimum successful percentage of 50, three instances must signal success.
     * If an instance doesn't send a signal within the time specified by the Timeout property, AWS CloudFormation assumes that the
     * instance wasn't created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getMinSuccessfulInstancesPercent();

    /**
     * @return a {@link Builder} of {@link CfnResourceAutoScalingCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnResourceAutoScalingCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Number _minSuccessfulInstancesPercent;

        /**
         * Sets the value of MinSuccessfulInstancesPercent
         * @param value Specifies the percentage of instances in an Auto Scaling replacement update that must signal success for the update to succeed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMinSuccessfulInstancesPercent(@javax.annotation.Nullable final java.lang.Number value) {
            this._minSuccessfulInstancesPercent = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceAutoScalingCreationPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnResourceAutoScalingCreationPolicy build() {
            return new CfnResourceAutoScalingCreationPolicy() {
                @javax.annotation.Nullable
                private final java.lang.Number $minSuccessfulInstancesPercent = _minSuccessfulInstancesPercent;

                @Override
                public java.lang.Number getMinSuccessfulInstancesPercent() {
                    return this.$minSuccessfulInstancesPercent;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getMinSuccessfulInstancesPercent() != null) {
                        obj.set("minSuccessfulInstancesPercent", om.valueToTree(this.getMinSuccessfulInstancesPercent()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Specifies the percentage of instances in an Auto Scaling replacement update that must signal success for the update to succeed.
         * 
         * You can specify a value from 0 to 100. AWS CloudFormation rounds to the nearest tenth of a percent.
         * For example, if you update five instances with a minimum successful percentage of 50, three instances must signal success.
         * If an instance doesn't send a signal within the time specified by the Timeout property, AWS CloudFormation assumes that the
         * instance wasn't created.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getMinSuccessfulInstancesPercent() {
            return this.jsiiGet("minSuccessfulInstancesPercent", java.lang.Number.class);
        }
    }
}
