package software.amazon.awscdk.core;

/**
 * Options for referencing a secret value from Secrets Manager.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:48:35.017Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SecretsManagerSecretOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * The key of a JSON field to retrieve.
     * 
     * This can only be used if the secret
     * stores a JSON object.
     * 
     * Default: - returns all the content stored in the Secrets Manager secret.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getJsonField();
    /**
     * Specifies the unique identifier of the version of the secret you want to use.
     * 
     * Can specify at most one of `versionId` and `versionStage`.
     * 
     * Default: AWSCURRENT
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getVersionId();
    /**
     * Specified the secret version that you want to retrieve by the staging label attached to the version.
     * 
     * Can specify at most one of `versionId` and `versionStage`.
     * 
     * Default: AWSCURRENT
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getVersionStage();

    /**
     * @return a {@link Builder} of {@link SecretsManagerSecretOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SecretsManagerSecretOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _jsonField;
        @javax.annotation.Nullable
        private java.lang.String _versionId;
        @javax.annotation.Nullable
        private java.lang.String _versionStage;

        /**
         * Sets the value of JsonField
         * @param value The key of a JSON field to retrieve.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withJsonField(@javax.annotation.Nullable final java.lang.String value) {
            this._jsonField = value;
            return this;
        }
        /**
         * Sets the value of VersionId
         * @param value Specifies the unique identifier of the version of the secret you want to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withVersionId(@javax.annotation.Nullable final java.lang.String value) {
            this._versionId = value;
            return this;
        }
        /**
         * Sets the value of VersionStage
         * @param value Specified the secret version that you want to retrieve by the staging label attached to the version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withVersionStage(@javax.annotation.Nullable final java.lang.String value) {
            this._versionStage = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecretsManagerSecretOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public SecretsManagerSecretOptions build() {
            return new SecretsManagerSecretOptions() {
                @javax.annotation.Nullable
                private final java.lang.String $jsonField = _jsonField;
                @javax.annotation.Nullable
                private final java.lang.String $versionId = _versionId;
                @javax.annotation.Nullable
                private final java.lang.String $versionStage = _versionStage;

                @Override
                public java.lang.String getJsonField() {
                    return this.$jsonField;
                }

                @Override
                public java.lang.String getVersionId() {
                    return this.$versionId;
                }

                @Override
                public java.lang.String getVersionStage() {
                    return this.$versionStage;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getJsonField() != null) {
                        obj.set("jsonField", om.valueToTree(this.getJsonField()));
                    }
                    if (this.getVersionId() != null) {
                        obj.set("versionId", om.valueToTree(this.getVersionId()));
                    }
                    if (this.getVersionStage() != null) {
                        obj.set("versionStage", om.valueToTree(this.getVersionStage()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.SecretsManagerSecretOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The key of a JSON field to retrieve.
         * 
         * This can only be used if the secret
         * stores a JSON object.
         * 
         * Default: - returns all the content stored in the Secrets Manager secret.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getJsonField() {
            return this.jsiiGet("jsonField", java.lang.String.class);
        }

        /**
         * Specifies the unique identifier of the version of the secret you want to use.
         * 
         * Can specify at most one of `versionId` and `versionStage`.
         * 
         * Default: AWSCURRENT
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getVersionId() {
            return this.jsiiGet("versionId", java.lang.String.class);
        }

        /**
         * Specified the secret version that you want to retrieve by the staging label attached to the version.
         * 
         * Can specify at most one of `versionId` and `versionStage`.
         * 
         * Default: AWSCURRENT
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getVersionStage() {
            return this.jsiiGet("versionStage", java.lang.String.class);
        }
    }
}
