package software.amazon.awscdk.core;

/**
 * CloudFormation intrinsic functions. http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference.html.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:48:35.003Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Fn")
public class Fn extends software.amazon.jsii.JsiiObject {
    protected Fn(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * The intrinsic function ``Fn::Base64`` returns the Base64 representation of the input string.
     * 
     * This function is typically used to pass encoded data to
     * Amazon EC2 instances by way of the UserData property.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string
     * @param data The string value you want to convert to Base64.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.lang.String base64(final java.lang.String data) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "base64", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(data, "data is required") });
    }

    /**
     * The intrinsic function ``Fn::Cidr`` returns the specified Cidr address block.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string
     * @param ipBlock The user-specified default Cidr address block.
     * @param count The number of subnets' Cidr block wanted.
     * @param sizeMask The digit covered in the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.util.List<java.lang.String> cidr(final java.lang.String ipBlock, final java.lang.Number count, @javax.annotation.Nullable final java.lang.String sizeMask) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "cidr", java.util.List.class, new Object[] { java.util.Objects.requireNonNull(ipBlock, "ipBlock is required"), java.util.Objects.requireNonNull(count, "count is required"), sizeMask });
    }

    /**
     * The intrinsic function ``Fn::Cidr`` returns the specified Cidr address block.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string
     * @param ipBlock The user-specified default Cidr address block.
     * @param count The number of subnets' Cidr block wanted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.util.List<java.lang.String> cidr(final java.lang.String ipBlock, final java.lang.Number count) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "cidr", java.util.List.class, new Object[] { java.util.Objects.requireNonNull(ipBlock, "ipBlock is required"), java.util.Objects.requireNonNull(count, "count is required") });
    }

    /**
     * Returns true if all the specified conditions evaluate to true, or returns false if any one of the conditions evaluates to false.
     * 
     * ``Fn::And`` acts as
     * an AND operator. The minimum number of conditions that you can include is
     * 2, and the maximum is 10.
     * 
     * EXPERIMENTAL
     * 
     * @return an FnCondition token
     * @param conditions conditions to AND.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.ICfnConditionExpression conditionAnd(final software.amazon.awscdk.core.ICfnConditionExpression... conditions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionAnd", software.amazon.awscdk.core.ICfnConditionExpression.class, java.util.Arrays.<Object>stream(conditions).toArray(Object[]::new));
    }

    /**
     * Returns true if a specified string matches at least one value in a list of strings.
     * 
     * EXPERIMENTAL
     * 
     * @return an FnCondition token
     * @param listOfStrings A list of strings, such as "A", "B", "C".
     * @param value A string, such as "A", that you want to compare against a list of strings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.ICfnConditionExpression conditionContains(final java.util.List<java.lang.String> listOfStrings, final java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionContains", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { java.util.Objects.requireNonNull(listOfStrings, "listOfStrings is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Returns true if a specified string matches all values in a list.
     * 
     * EXPERIMENTAL
     * 
     * @return an FnCondition token
     * @param listOfStrings A list of strings, such as "A", "B", "C".
     * @param value A string, such as "A", that you want to compare against a list of strings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.ICfnConditionExpression conditionEachMemberEquals(final java.util.List<java.lang.String> listOfStrings, final java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionEachMemberEquals", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { java.util.Objects.requireNonNull(listOfStrings, "listOfStrings is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Returns true if each member in a list of strings matches at least one value in a second list of strings.
     * 
     * EXPERIMENTAL
     * 
     * @return an FnCondition token
     * @param stringsToCheck A list of strings, such as "A", "B", "C".
     * @param stringsToMatch A list of strings, such as "A", "B", "C".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.ICfnConditionExpression conditionEachMemberIn(final java.util.List<java.lang.String> stringsToCheck, final java.util.List<java.lang.String> stringsToMatch) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionEachMemberIn", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { java.util.Objects.requireNonNull(stringsToCheck, "stringsToCheck is required"), java.util.Objects.requireNonNull(stringsToMatch, "stringsToMatch is required") });
    }

    /**
     * Compares if two values are equal.
     * 
     * Returns true if the two values are equal
     * or false if they aren't.
     * 
     * EXPERIMENTAL
     * 
     * @return an FnCondition token
     * @param lhs A value of any type that you want to compare.
     * @param rhs A value of any type that you want to compare.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.ICfnConditionExpression conditionEquals(@javax.annotation.Nullable final java.lang.Object lhs, @javax.annotation.Nullable final java.lang.Object rhs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionEquals", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { lhs, rhs });
    }

    /**
     * Returns one value if the specified condition evaluates to true and another value if the specified condition evaluates to false.
     * 
     * Currently, AWS
     * CloudFormation supports the ``Fn::If`` intrinsic function in the metadata
     * attribute, update policy attribute, and property values in the Resources
     * section and Outputs sections of a template. You can use the AWS::NoValue
     * pseudo parameter as a return value to remove the corresponding property.
     * 
     * EXPERIMENTAL
     * 
     * @return an FnCondition token
     * @param conditionId A reference to a condition in the Conditions section.
     * @param valueIfTrue A value to be returned if the specified condition evaluates to true.
     * @param valueIfFalse A value to be returned if the specified condition evaluates to false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.ICfnConditionExpression conditionIf(final java.lang.String conditionId, @javax.annotation.Nullable final java.lang.Object valueIfTrue, @javax.annotation.Nullable final java.lang.Object valueIfFalse) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionIf", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { java.util.Objects.requireNonNull(conditionId, "conditionId is required"), valueIfTrue, valueIfFalse });
    }

    /**
     * Returns true for a condition that evaluates to false or returns false for a condition that evaluates to true.
     * 
     * ``Fn::Not`` acts as a NOT operator.
     * 
     * EXPERIMENTAL
     * 
     * @return an FnCondition token
     * @param condition A condition such as ``Fn::Equals`` that evaluates to true or false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.ICfnConditionExpression conditionNot(final software.amazon.awscdk.core.ICfnConditionExpression condition) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionNot", software.amazon.awscdk.core.ICfnConditionExpression.class, new Object[] { java.util.Objects.requireNonNull(condition, "condition is required") });
    }

    /**
     * Returns true if any one of the specified conditions evaluate to true, or returns false if all of the conditions evaluates to false.
     * 
     * ``Fn::Or`` acts
     * as an OR operator. The minimum number of conditions that you can include is
     * 2, and the maximum is 10.
     * 
     * EXPERIMENTAL
     * 
     * @return an FnCondition token
     * @param conditions conditions that evaluates to true or false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.ICfnConditionExpression conditionOr(final software.amazon.awscdk.core.ICfnConditionExpression... conditions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "conditionOr", software.amazon.awscdk.core.ICfnConditionExpression.class, java.util.Arrays.<Object>stream(conditions).toArray(Object[]::new));
    }

    /**
     * The intrinsic function ``Fn::FindInMap`` returns the value corresponding to keys in a two-level map that is declared in the Mappings section.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.lang.String findInMap(final java.lang.String mapName, final java.lang.String topLevelKey, final java.lang.String secondLevelKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "findInMap", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(mapName, "mapName is required"), java.util.Objects.requireNonNull(topLevelKey, "topLevelKey is required"), java.util.Objects.requireNonNull(secondLevelKey, "secondLevelKey is required") });
    }

    /**
     * The ``Fn::GetAtt`` intrinsic function returns the value of an attribute from a resource in the template.
     * 
     * EXPERIMENTAL
     * 
     * @return a CloudFormationToken object
     * @param logicalNameOfResource The logical name (also called logical ID) of the resource that contains the attribute that you want.
     * @param attributeName The name of the resource-specific attribute whose value you want.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.Token getAtt(final java.lang.String logicalNameOfResource, final java.lang.String attributeName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "getAtt", software.amazon.awscdk.core.Token.class, new Object[] { java.util.Objects.requireNonNull(logicalNameOfResource, "logicalNameOfResource is required"), java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * The intrinsic function ``Fn::GetAZs`` returns an array that lists Availability Zones for a specified region.
     * 
     * Because customers have access to
     * different Availability Zones, the intrinsic function ``Fn::GetAZs`` enables
     * template authors to write templates that adapt to the calling user's
     * access. That way you don't have to hard-code a full list of Availability
     * Zones for a specified region.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string array
     * @param region The name of the region for which you want to get the Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.util.List<java.lang.String> getAZs(@javax.annotation.Nullable final java.lang.String region) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "getAZs", java.util.List.class, new Object[] { region });
    }

    /**
     * The intrinsic function ``Fn::GetAZs`` returns an array that lists Availability Zones for a specified region.
     * 
     * Because customers have access to
     * different Availability Zones, the intrinsic function ``Fn::GetAZs`` enables
     * template authors to write templates that adapt to the calling user's
     * access. That way you don't have to hard-code a full list of Availability
     * Zones for a specified region.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string array
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.util.List<java.lang.String> getAZs() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "getAZs", java.util.List.class);
    }

    /**
     * The intrinsic function ``Fn::ImportValue`` returns the value of an output exported by another stack.
     * 
     * You typically use this function to create
     * cross-stack references. In the following example template snippets, Stack A
     * exports VPC security group values and Stack B imports them.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string
     * @param sharedValueToImport The stack output value that you want to import.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.lang.String importValue(final java.lang.String sharedValueToImport) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "importValue", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(sharedValueToImport, "sharedValueToImport is required") });
    }

    /**
     * The intrinsic function ``Fn::Join`` appends a set of values into a single value, separated by the specified delimiter.
     * 
     * If a delimiter is the empty
     * string, the set of values are concatenated with no delimiter.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string
     * @param delimiter The value you want to occur between fragments.
     * @param listOfValues The list of values you want combined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.lang.String join(final java.lang.String delimiter, final java.util.List<java.lang.String> listOfValues) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "join", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(delimiter, "delimiter is required"), java.util.Objects.requireNonNull(listOfValues, "listOfValues is required") });
    }

    /**
     * Returns all values for a specified parameter type.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string array
     * @param parameterType An AWS-specific parameter type, such as AWS::EC2::SecurityGroup::Id or AWS::EC2::VPC::Id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.util.List<java.lang.String> refAll(final java.lang.String parameterType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "refAll", java.util.List.class, new Object[] { java.util.Objects.requireNonNull(parameterType, "parameterType is required") });
    }

    /**
     * The intrinsic function ``Fn::Select`` returns a single object from a list of objects by index.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string
     * @param index The index of the object to retrieve.
     * @param array The list of objects to select from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.lang.String select(final java.lang.Number index, final java.util.List<java.lang.String> array) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "select", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(array, "array is required") });
    }

    /**
     * To split a string into a list of string values so that you can select an element from the resulting string list, use the ``Fn::Split`` intrinsic function.
     * 
     * Specify the location of splits
     * with a delimiter, such as , (a comma). After you split a string, use the ``Fn::Select`` function
     * to pick a specific element.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string array
     * @param delimiter A string value that determines where the source string is divided.
     * @param source The string value that you want to split.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.util.List<java.lang.String> split(final java.lang.String delimiter, final java.lang.String source) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "split", java.util.List.class, new Object[] { java.util.Objects.requireNonNull(delimiter, "delimiter is required"), java.util.Objects.requireNonNull(source, "source is required") });
    }

    /**
     * The intrinsic function ``Fn::Sub`` substitutes variables in an input string with values that you specify.
     * 
     * In your templates, you can use this function
     * to construct commands or outputs that include values that aren't available
     * until you create or update a stack.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string
     * @param body A string with variables that AWS CloudFormation substitutes with their associated values at runtime.
     * @param variables The name of a variable that you included in the String parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.lang.String sub(final java.lang.String body, @javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> variables) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "sub", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(body, "body is required"), variables });
    }

    /**
     * The intrinsic function ``Fn::Sub`` substitutes variables in an input string with values that you specify.
     * 
     * In your templates, you can use this function
     * to construct commands or outputs that include values that aren't available
     * until you create or update a stack.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string
     * @param body A string with variables that AWS CloudFormation substitutes with their associated values at runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.lang.String sub(final java.lang.String body) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "sub", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(body, "body is required") });
    }

    /**
     * Returns an attribute value or list of values for a specific parameter and attribute.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string
     * @param parameterOrLogicalId The name of a parameter for which you want to retrieve attribute values.
     * @param attribute The name of an attribute from which you want to retrieve a value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.lang.String valueOf(final java.lang.String parameterOrLogicalId, final java.lang.String attribute) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "valueOf", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(parameterOrLogicalId, "parameterOrLogicalId is required"), java.util.Objects.requireNonNull(attribute, "attribute is required") });
    }

    /**
     * Returns a list of all attribute values for a given parameter type and attribute.
     * 
     * EXPERIMENTAL
     * 
     * @return a token represented as a string array
     * @param parameterType An AWS-specific parameter type, such as AWS::EC2::SecurityGroup::Id or AWS::EC2::VPC::Id.
     * @param attribute The name of an attribute from which you want to retrieve a value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.util.List<java.lang.String> valueOfAll(final java.lang.String parameterType, final java.lang.String attribute) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Fn.class, "valueOfAll", java.util.List.class, new Object[] { java.util.Objects.requireNonNull(parameterType, "parameterType is required"), java.util.Objects.requireNonNull(attribute, "attribute is required") });
    }
}
