package software.amazon.awscdk.core;

/**
 * Represents a length of time.
 * 
 * The amount can be specified either as a literal value (e.g: `10`) which
 * cannot be negative, or as an unresolved number token.
 * 
 * Whent he amount is passed as an token, unit conversion is not possible.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:48:35.003Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Duration")
public class Duration extends software.amazon.jsii.JsiiObject {
    protected Duration(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * EXPERIMENTAL
     * 
     * @return a new `Duration` representing `amount` Days.
     * @param amount the amount of Days the `Duration` will represent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.Duration days(final java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "days", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * EXPERIMENTAL
     * 
     * @return a new `Duration` representing `amount` Hours.
     * @param amount the amount of Hours the `Duration` will represent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.Duration hours(final java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "hours", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * EXPERIMENTAL
     * 
     * @return a new `Duration` representing `amount` Minutes.
     * @param amount the amount of Minutes the `Duration` will represent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.Duration minutes(final java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "minutes", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Parse a period formatted according to the ISO 8601 standard (see https://www.iso.org/fr/standard/70907.html).
     * 
     * EXPERIMENTAL
     * 
     * @return the parsed `Duration`.
     * @param duration an ISO-formtted duration to be parsed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.Duration parse(final java.lang.String duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "parse", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * EXPERIMENTAL
     * 
     * @return a new `Duration` representing `amount` Seconds.
     * @param amount the amount of Seconds the `Duration` will represent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.core.Duration seconds(final java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "seconds", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * EXPERIMENTAL
     * 
     * @return the value of this `Duration` expressed in Days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Number toDays(@javax.annotation.Nullable final software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toDays", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * EXPERIMENTAL
     * 
     * @return the value of this `Duration` expressed in Days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Number toDays() {
        return this.jsiiCall("toDays", java.lang.Number.class);
    }

    /**
     * EXPERIMENTAL
     * 
     * @return the value of this `Duration` expressed in Hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Number toHours(@javax.annotation.Nullable final software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toHours", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * EXPERIMENTAL
     * 
     * @return the value of this `Duration` expressed in Hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Number toHours() {
        return this.jsiiCall("toHours", java.lang.Number.class);
    }

    /**
     * EXPERIMENTAL
     * 
     * @return an ISO 8601 representation of this period (see https://www.iso.org/fr/standard/70907.html).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String toISOString() {
        return this.jsiiCall("toISOString", java.lang.String.class);
    }

    /**
     * EXPERIMENTAL
     * 
     * @return the value of this `Duration` expressed in Minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Number toMinutes(@javax.annotation.Nullable final software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toMinutes", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * EXPERIMENTAL
     * 
     * @return the value of this `Duration` expressed in Minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Number toMinutes() {
        return this.jsiiCall("toMinutes", java.lang.Number.class);
    }

    /**
     * EXPERIMENTAL
     * 
     * @return the value of this `Duration` expressed in Seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Number toSeconds(@javax.annotation.Nullable final software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toSeconds", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * EXPERIMENTAL
     * 
     * @return the value of this `Duration` expressed in Seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Number toSeconds() {
        return this.jsiiCall("toSeconds", java.lang.Number.class);
    }

    /**
     * Returns a string representation of this `Duration` that is also a Token that cannot be successfully resolved.
     * 
     * This
     * protects users against inadvertently stringifying a `Duration` object, when they should have called one of the
     * `to*` methods instead.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }
}
