package software.amazon.awscdk.core;

/**
 * Associate the CreationPolicy attribute with a resource to prevent its status from reaching create complete until AWS CloudFormation receives a specified number of success signals or the timeout period is exceeded.
 * 
 * To signal a
 * resource, you can use the cfn-signal helper script or SignalResource API. AWS CloudFormation publishes valid signals
 * to the stack events so that you track the number of signals sent.
 * 
 * The creation policy is invoked only when AWS CloudFormation creates the associated resource. Currently, the only
 * AWS CloudFormation resources that support creation policies are AWS::AutoScaling::AutoScalingGroup, AWS::EC2::Instance,
 * and AWS::CloudFormation::WaitCondition.
 * 
 * Use the CreationPolicy attribute when you want to wait on resource configuration actions before stack creation proceeds.
 * For example, if you install and configure software applications on an EC2 instance, you might want those applications to
 * be running before proceeding. In such cases, you can add a CreationPolicy attribute to the instance, and then send a success
 * signal to the instance after the applications are installed and configured. For a detailed example, see Deploying Applications
 * on Amazon EC2 with AWS CloudFormation.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:48:34.991Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CfnCreationPolicy extends software.amazon.jsii.JsiiSerializable {
    /**
     * For an Auto Scaling group replacement update, specifies how many instances must signal success for the update to succeed.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy getAutoScalingCreationPolicy();
    /**
     * When AWS CloudFormation creates the associated resource, configures the number of required success signals and the length of time that AWS CloudFormation waits for those signals.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.core.CfnResourceSignal getResourceSignal();

    /**
     * @return a {@link Builder} of {@link CfnCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy _autoScalingCreationPolicy;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.CfnResourceSignal _resourceSignal;

        /**
         * Sets the value of AutoScalingCreationPolicy
         * @param value For an Auto Scaling group replacement update, specifies how many instances must signal success for the update to succeed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAutoScalingCreationPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy value) {
            this._autoScalingCreationPolicy = value;
            return this;
        }
        /**
         * Sets the value of ResourceSignal
         * @param value When AWS CloudFormation creates the associated resource, configures the number of required success signals and the length of time that AWS CloudFormation waits for those signals.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withResourceSignal(@javax.annotation.Nullable final software.amazon.awscdk.core.CfnResourceSignal value) {
            this._resourceSignal = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCreationPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public CfnCreationPolicy build() {
            return new CfnCreationPolicy() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy $autoScalingCreationPolicy = _autoScalingCreationPolicy;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.CfnResourceSignal $resourceSignal = _resourceSignal;

                @Override
                public software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy getAutoScalingCreationPolicy() {
                    return this.$autoScalingCreationPolicy;
                }

                @Override
                public software.amazon.awscdk.core.CfnResourceSignal getResourceSignal() {
                    return this.$resourceSignal;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getAutoScalingCreationPolicy() != null) {
                        obj.set("autoScalingCreationPolicy", om.valueToTree(this.getAutoScalingCreationPolicy()));
                    }
                    if (this.getResourceSignal() != null) {
                        obj.set("resourceSignal", om.valueToTree(this.getResourceSignal()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.CfnCreationPolicy {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * For an Auto Scaling group replacement update, specifies how many instances must signal success for the update to succeed.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy getAutoScalingCreationPolicy() {
            return this.jsiiGet("autoScalingCreationPolicy", software.amazon.awscdk.core.CfnResourceAutoScalingCreationPolicy.class);
        }

        /**
         * When AWS CloudFormation creates the associated resource, configures the number of required success signals and the length of time that AWS CloudFormation waits for those signals.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.CfnResourceSignal getResourceSignal() {
            return this.jsiiGet("resourceSignal", software.amazon.awscdk.core.CfnResourceSignal.class);
        }
    }
}
