/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.ConstructOrder;
import software.amazon.awscdk.core.Dependency;
import software.amazon.awscdk.core.IAspect;
import software.amazon.awscdk.core.IConstruct;
import software.amazon.awscdk.core.IDependable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.OutgoingReference;
import software.amazon.awscdk.core.SynthesisOptions;
import software.amazon.awscdk.core.ValidationError;
import software.amazon.awscdk.cxapi.CloudAssembly;
import software.amazon.awscdk.cxapi.MetadataEntry;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;

@Jsii(module=.Module.class, fqn="@aws-cdk/core.ConstructNode")
public class ConstructNode
extends JsiiObject {
    public static final String PATH_SEP = (String)JsiiObject.jsiiStaticGet(ConstructNode.class, (String)"PATH_SEP", String.class);

    protected ConstructNode(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public ConstructNode(Construct host, IConstruct scope, String id) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(host, "host is required"), Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public static void prepare(ConstructNode node) {
        JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"prepare", Void.class, (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    public static CloudAssembly synth(ConstructNode root, @Nullable SynthesisOptions options) {
        return (CloudAssembly)JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"synth", CloudAssembly.class, (Object[])new Object[]{Objects.requireNonNull(root, "root is required"), options});
    }

    public static CloudAssembly synth(ConstructNode root) {
        return (CloudAssembly)JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"synth", CloudAssembly.class, (Object[])new Object[]{Objects.requireNonNull(root, "root is required")});
    }

    public static List<ValidationError> validate(ConstructNode node) {
        return (List)JsiiObject.jsiiStaticCall(ConstructNode.class, (String)"validate", List.class, (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    public void addDependency(IDependable ... dependencies) {
        this.jsiiCall("addDependency", Void.class, Arrays.stream(dependencies).toArray(Object[]::new));
    }

    public void addError(String message) {
        this.jsiiCall("addError", Void.class, new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void addInfo(String message) {
        this.jsiiCall("addInfo", Void.class, new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void addMetadata(String type, @Nullable Object data, @Nullable Object from) {
        this.jsiiCall("addMetadata", Void.class, new Object[]{Objects.requireNonNull(type, "type is required"), data, from});
    }

    public void addMetadata(String type, @Nullable Object data) {
        this.jsiiCall("addMetadata", Void.class, new Object[]{Objects.requireNonNull(type, "type is required"), data});
    }

    public void addReference(IResolvable ... refs) {
        this.jsiiCall("addReference", Void.class, Arrays.stream(refs).toArray(Object[]::new));
    }

    public void addWarning(String message) {
        this.jsiiCall("addWarning", Void.class, new Object[]{Objects.requireNonNull(message, "message is required")});
    }

    public void applyAspect(IAspect aspect) {
        this.jsiiCall("applyAspect", Void.class, new Object[]{Objects.requireNonNull(aspect, "aspect is required")});
    }

    public List<IConstruct> findAll(@Nullable ConstructOrder order) {
        return (List)this.jsiiCall("findAll", List.class, new Object[]{order});
    }

    public List<IConstruct> findAll() {
        return (List)this.jsiiCall("findAll", List.class, new Object[0]);
    }

    public IConstruct findChild(String path) {
        return (IConstruct)this.jsiiCall("findChild", IConstruct.class, new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    public void setContext(String key, @Nullable Object value) {
        this.jsiiCall("setContext", Void.class, new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    @Nullable
    public IConstruct tryFindChild(String path) {
        return (IConstruct)this.jsiiCall("tryFindChild", IConstruct.class, new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    @Nullable
    public Object tryGetContext(String key) {
        return this.jsiiCall("tryGetContext", Object.class, new Object[]{Objects.requireNonNull(key, "key is required")});
    }

    public List<IConstruct> getChildren() {
        return (List)this.jsiiGet("children", List.class);
    }

    public List<Dependency> getDependencies() {
        return (List)this.jsiiGet("dependencies", List.class);
    }

    public String getId() {
        return (String)this.jsiiGet("id", String.class);
    }

    public Boolean getLocked() {
        return (Boolean)this.jsiiGet("locked", Boolean.class);
    }

    public List<MetadataEntry> getMetadata() {
        return (List)this.jsiiGet("metadata", List.class);
    }

    public String getPath() {
        return (String)this.jsiiGet("path", String.class);
    }

    public List<OutgoingReference> getReferences() {
        return (List)this.jsiiGet("references", List.class);
    }

    public IConstruct getRoot() {
        return (IConstruct)this.jsiiGet("root", IConstruct.class);
    }

    public List<IConstruct> getScopes() {
        return (List)this.jsiiGet("scopes", List.class);
    }

    public String getUniqueId() {
        return (String)this.jsiiGet("uniqueId", String.class);
    }

    @Nullable
    public IConstruct getDefaultChild() {
        return (IConstruct)this.jsiiGet("defaultChild", IConstruct.class);
    }

    @Nullable
    public IConstruct getScope() {
        return (IConstruct)this.jsiiGet("scope", IConstruct.class);
    }
}

