/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.CfnCondition;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnOutputProps
extends JsiiSerializable {
    public String getValue();

    public CfnCondition getCondition();

    public String getDescription();

    public String getExportName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _value;
        @Nullable
        private CfnCondition _condition;
        @Nullable
        private String _description;
        @Nullable
        private String _exportName;

        public Builder withValue(String value) {
            this._value = Objects.requireNonNull(value, "value is required");
            return this;
        }

        public Builder withCondition(@Nullable CfnCondition value) {
            this._condition = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withExportName(@Nullable String value) {
            this._exportName = value;
            return this;
        }

        public CfnOutputProps build() {
            return new CfnOutputProps(){
                private final String $value;
                @Nullable
                private final CfnCondition $condition;
                @Nullable
                private final String $description;
                @Nullable
                private final String $exportName;
                {
                    this.$value = Objects.requireNonNull(_value, "value is required");
                    this.$condition = _condition;
                    this.$description = _description;
                    this.$exportName = _exportName;
                }

                @Override
                public String getValue() {
                    return this.$value;
                }

                @Override
                public CfnCondition getCondition() {
                    return this.$condition;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getExportName() {
                    return this.$exportName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("value", om.valueToTree((Object)this.getValue()));
                    if (this.getCondition() != null) {
                        obj.set("condition", om.valueToTree((Object)this.getCondition()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getExportName() != null) {
                        obj.set("exportName", om.valueToTree((Object)this.getExportName()));
                    }
                    return obj;
                }
            };
        }
    }
}

