package software.amazon.awscdk.core;

/**
 * Represents the construct node in the scope tree.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.12.1 (build 3ce4842)", date = "2019-06-25T13:54:15.888Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.ConstructNode")
public class ConstructNode extends software.amazon.jsii.JsiiObject {
    protected ConstructNode(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        PATH_SEP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.ConstructNode.class, "PATH_SEP", java.lang.String.class);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ConstructNode(final software.amazon.awscdk.core.Construct host, final software.amazon.awscdk.core.IConstruct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(host, "host is required"), java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Invokes "prepare" on all constructs (depth-first, post-order) in the tree under `node`.
     * 
     * EXPERIMENTAL
     * 
     * @param node The root node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static void prepare(final software.amazon.awscdk.core.ConstructNode node) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.ConstructNode.class, "prepare", Void.class, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Synthesizes a CloudAssembly from a construct tree.
     * 
     * EXPERIMENTAL
     * 
     * @param root The root of the construct tree.
     * @param options Synthesis options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.cxapi.CloudAssembly synth(final software.amazon.awscdk.core.ConstructNode root, @javax.annotation.Nullable final software.amazon.awscdk.core.SynthesisOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.ConstructNode.class, "synth", software.amazon.awscdk.cxapi.CloudAssembly.class, new Object[] { java.util.Objects.requireNonNull(root, "root is required"), options });
    }

    /**
     * Synthesizes a CloudAssembly from a construct tree.
     * 
     * EXPERIMENTAL
     * 
     * @param root The root of the construct tree.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.cxapi.CloudAssembly synth(final software.amazon.awscdk.core.ConstructNode root) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.ConstructNode.class, "synth", software.amazon.awscdk.cxapi.CloudAssembly.class, new Object[] { java.util.Objects.requireNonNull(root, "root is required") });
    }

    /**
     * Invokes "validate" on all constructs in the tree (depth-first, pre-order) and returns the list of all errors.
     * 
     * An empty list indicates that there are no errors.
     * 
     * EXPERIMENTAL
     * 
     * @param node The root node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.util.List<software.amazon.awscdk.core.ValidationError> validate(final software.amazon.awscdk.core.ConstructNode node) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.ConstructNode.class, "validate", java.util.List.class, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Add an ordering dependency on another Construct.
     * 
     * All constructs in the dependency's scope will be deployed before any
     * construct in this construct's scope.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addDependency(final software.amazon.awscdk.core.IDependable... dependencies) {
        this.jsiiCall("addDependency", Void.class, java.util.Arrays.<Object>stream(dependencies).toArray(Object[]::new));
    }

    /**
     * Adds an { error: <message> } metadata entry to this construct. The toolkit will fail synthesis when errors are reported.
     * 
     * EXPERIMENTAL
     * 
     * @param message The error message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addError(final java.lang.String message) {
        this.jsiiCall("addError", Void.class, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Adds a { "aws:cdk:info": <message> } metadata entry to this construct. The toolkit will display the info message when apps are synthesized.
     * 
     * EXPERIMENTAL
     * 
     * @param message The info message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addInfo(final java.lang.String message) {
        this.jsiiCall("addInfo", Void.class, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Adds a metadata entry to this construct. Entries are arbitrary values and will also include a stack trace to allow tracing back to the code location for when the entry was added. It can be used, for example, to include source mapping in CloudFormation templates to improve diagnostics.
     * 
     * EXPERIMENTAL
     * 
     * @param type a string denoting the type of metadata.
     * @param data the value of the metadata (can be a Token).
     * @param from a function under which to restrict the metadata entry's stack trace (defaults to this.addMetadata).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addMetadata(final java.lang.String type, @javax.annotation.Nullable final java.lang.Object data, @javax.annotation.Nullable final java.lang.Object from) {
        this.jsiiCall("addMetadata", Void.class, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), data, from });
    }

    /**
     * Adds a metadata entry to this construct. Entries are arbitrary values and will also include a stack trace to allow tracing back to the code location for when the entry was added. It can be used, for example, to include source mapping in CloudFormation templates to improve diagnostics.
     * 
     * EXPERIMENTAL
     * 
     * @param type a string denoting the type of metadata.
     * @param data the value of the metadata (can be a Token).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addMetadata(final java.lang.String type, @javax.annotation.Nullable final java.lang.Object data) {
        this.jsiiCall("addMetadata", Void.class, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), data });
    }

    /**
     * Record a reference originating from this construct node.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addReference(final software.amazon.awscdk.core.IResolvable... refs) {
        this.jsiiCall("addReference", Void.class, java.util.Arrays.<Object>stream(refs).toArray(Object[]::new));
    }

    /**
     * Adds a { warning: <message> } metadata entry to this construct. The toolkit will display the warning when an app is synthesized, or fail if run in --strict mode.
     * 
     * EXPERIMENTAL
     * 
     * @param message The warning message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addWarning(final java.lang.String message) {
        this.jsiiCall("addWarning", Void.class, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Applies the aspect to this Constructs node.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void applyAspect(final software.amazon.awscdk.core.IAspect aspect) {
        this.jsiiCall("applyAspect", Void.class, new Object[] { java.util.Objects.requireNonNull(aspect, "aspect is required") });
    }

    /**
     * Return this construct and all of its children in the given order.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.core.IConstruct> findAll(@javax.annotation.Nullable final software.amazon.awscdk.core.ConstructOrder order) {
        return this.jsiiCall("findAll", java.util.List.class, new Object[] { order });
    }

    /**
     * Return this construct and all of its children in the given order.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.core.IConstruct> findAll() {
        return this.jsiiCall("findAll", java.util.List.class);
    }

    /**
     * Return a descendant by path.
     * 
     * Throws an error if the descendant is not found.
     * 
     * Note that if the original ID of the construct you are looking for contained
     * a '/', then it would have been replaced by '--'.
     * 
     * EXPERIMENTAL
     * 
     * @return Child with the given path.
     * @param path Relative path of a direct or indirect child.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.core.IConstruct findChild(final java.lang.String path) {
        return this.jsiiCall("findChild", software.amazon.awscdk.core.IConstruct.class, new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * This can be used to set contextual values. Context must be set before any children are added, since children may consult context info during construction. If the key already exists, it will be overridden.
     * 
     * EXPERIMENTAL
     * 
     * @param key The context key.
     * @param value The context value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setContext(final java.lang.String key, @javax.annotation.Nullable final java.lang.Object value) {
        this.jsiiCall("setContext", Void.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Return a descendant by path, or undefined.
     * 
     * Note that if the original ID of the construct you are looking for contained
     * a '/', then it would have been replaced by '--'.
     * 
     * EXPERIMENTAL
     * 
     * @return a child by path or undefined if not found.
     * @param path Relative path of a direct or indirect child.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @javax.annotation.Nullable
    public software.amazon.awscdk.core.IConstruct tryFindChild(final java.lang.String path) {
        return this.jsiiCall("tryFindChild", software.amazon.awscdk.core.IConstruct.class, new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Retrieves a value from tree context.
     * 
     * Context is usually initialized at the root, but can be overridden at any point in the tree.
     * 
     * EXPERIMENTAL
     * 
     * @return The context value or `undefined` if there is no context value for thie key.
     * @param key The context key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @javax.annotation.Nullable
    public java.lang.Object tryGetContext(final java.lang.String key) {
        return this.jsiiCall("tryGetContext", java.lang.Object.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }
    /**
     * Separator used to delimit construct path components.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String PATH_SEP;

    /**
     * All direct children of this construct.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.core.IConstruct> getChildren() {
        return this.jsiiGet("children", java.util.List.class);
    }

    /**
     * Return all dependencies registered on this node or any of its children.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.core.Dependency> getDependencies() {
        return this.jsiiGet("dependencies", java.util.List.class);
    }

    /**
     * The id of this construct within the current scope.
     * 
     * This is a a scope-unique id. To obtain an app-unique id for this construct, use `uniqueId`.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getId() {
        return this.jsiiGet("id", java.lang.String.class);
    }

    /**
     * Returns true if this construct or the scopes in which it is defined are locked.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Boolean getLocked() {
        return this.jsiiGet("locked", java.lang.Boolean.class);
    }

    /**
     * An immutable array of metadata objects associated with this construct. This can be used, for example, to implement support for deprecation notices, source mapping, etc.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.cxapi.MetadataEntry> getMetadata() {
        return this.jsiiGet("metadata", java.util.List.class);
    }

    /**
     * The full, absolute path of this construct in the tree.
     * 
     * Components are separated by '/'.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getPath() {
        return this.jsiiGet("path", java.lang.String.class);
    }

    /**
     * Return all references originating from this node or any of its children.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.core.OutgoingReference> getReferences() {
        return this.jsiiGet("references", java.util.List.class);
    }

    /**
     * EXPERIMENTAL
     * 
     * @return The root of the construct tree.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.core.IConstruct getRoot() {
        return this.jsiiGet("root", software.amazon.awscdk.core.IConstruct.class);
    }

    /**
     * All parent scopes of this construct.
     * 
     * EXPERIMENTAL
     * 
     * @return a list of parent scopes. The last element in the list will always
     * be the current construct and the first element will be the root of the
     * tree.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.core.IConstruct> getScopes() {
        return this.jsiiGet("scopes", java.util.List.class);
    }

    /**
     * A tree-global unique alphanumeric identifier for this construct. Includes all components of the tree.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getUniqueId() {
        return this.jsiiGet("uniqueId", java.lang.String.class);
    }

    /**
     * Returns the child construct that has the id `Default` or `Resource"`.
     * 
     * EXPERIMENTAL
     * 
     * @return a construct or undefined if there is no default child
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @javax.annotation.Nullable
    public software.amazon.awscdk.core.IConstruct getDefaultChild() {
        return this.jsiiGet("defaultChild", software.amazon.awscdk.core.IConstruct.class);
    }

    /**
     * Returns the scope in which this construct is defined.
     * 
     * The value is `undefined` at the root of the construct scope tree.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @javax.annotation.Nullable
    public software.amazon.awscdk.core.IConstruct getScope() {
        return this.jsiiGet("scope", software.amazon.awscdk.core.IConstruct.class);
    }
}
