package software.amazon.awscdk.core;

/**
 * A rule can include a RuleCondition property and must include an Assertions property. For each rule, you can define only one rule condition; you can define one or more asserts within the Assertions property. You define a rule condition and assertions by using rule-specific intrinsic functions.
 * 
 * You can use the following rule-specific intrinsic functions to define rule conditions and assertions:
 * 
 *   Fn::And
 *   Fn::Contains
 *   Fn::EachMemberEquals
 *   Fn::EachMemberIn
 *   Fn::Equals
 *   Fn::If
 *   Fn::Not
 *   Fn::Or
 *   Fn::RefAll
 *   Fn::ValueOf
 *   Fn::ValueOfAll
 * 
 * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.12.1 (build 3ce4842)", date = "2019-06-25T13:54:15.887Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CfnRuleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Assertions which define the rule.
     * 
     * Default: - No assertions for the rule.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> getAssertions();
    /**
     * If the rule condition evaluates to false, the rule doesn't take effect. If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
     * 
     * Default: - Rule's assertions will always take effect.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.core.ICfnConditionExpression getRuleCondition();

    /**
     * @return a {@link Builder} of {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> _assertions;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.ICfnConditionExpression _ruleCondition;

        /**
         * Sets the value of Assertions
         * @param value Assertions which define the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAssertions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> value) {
            this._assertions = value;
            return this;
        }
        /**
         * Sets the value of RuleCondition
         * @param value If the rule condition evaluates to false, the rule doesn't take effect. If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.core.ICfnConditionExpression value) {
            this._ruleCondition = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public CfnRuleProps build() {
            return new CfnRuleProps() {
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> $assertions = _assertions;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.ICfnConditionExpression $ruleCondition = _ruleCondition;

                @Override
                public java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> getAssertions() {
                    return this.$assertions;
                }

                @Override
                public software.amazon.awscdk.core.ICfnConditionExpression getRuleCondition() {
                    return this.$ruleCondition;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getAssertions() != null) {
                        obj.set("assertions", om.valueToTree(this.getAssertions()));
                    }
                    if (this.getRuleCondition() != null) {
                        obj.set("ruleCondition", om.valueToTree(this.getRuleCondition()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.CfnRuleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Assertions which define the rule.
         * 
         * Default: - No assertions for the rule.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> getAssertions() {
            return this.jsiiGet("assertions", java.util.List.class);
        }

        /**
         * If the rule condition evaluates to false, the rule doesn't take effect. If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
         * 
         * Default: - Rule's assertions will always take effect.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.ICfnConditionExpression getRuleCondition() {
            return this.jsiiGet("ruleCondition", software.amazon.awscdk.core.ICfnConditionExpression.class);
        }
    }
}
