package software.amazon.awscdk.services.cognito;

/**
 * User pool configuration for user self sign up.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.729Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserVerificationConfig")
@software.amazon.jsii.Jsii.Proxy(UserVerificationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserVerificationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The email body template for the verification email sent to the user upon sign up.
     * <p>
     * See https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-templates.html to
     * learn more about message templates.
     * <p>
     * Default: - 'The verification code to your new account is {####}' if VerificationEmailStyle.CODE is chosen,
     * 'Verify your account by clicking on {##Verify Email##}' if VerificationEmailStyle.LINK is chosen.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailBody() {
        return null;
    }

    /**
     * Emails can be verified either using a code or a link.
     * <p>
     * Learn more at https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-email-verification-message-customization.html
     * <p>
     * Default: VerificationEmailStyle.CODE
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.VerificationEmailStyle getEmailStyle() {
        return null;
    }

    /**
     * The email subject template for the verification email sent to the user upon sign up.
     * <p>
     * See https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-templates.html to
     * learn more about message templates.
     * <p>
     * Default: 'Verify your new account'
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailSubject() {
        return null;
    }

    /**
     * The message template for the verification SMS sent to the user upon sign up.
     * <p>
     * See https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-templates.html to
     * learn more about message templates.
     * <p>
     * Default: - 'The verification code to your new account is {####}' if VerificationEmailStyle.CODE is chosen,
     * not configured if VerificationEmailStyle.LINK is chosen
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSmsMessage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserVerificationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserVerificationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserVerificationConfig> {
        private java.lang.String emailBody;
        private software.amazon.awscdk.services.cognito.VerificationEmailStyle emailStyle;
        private java.lang.String emailSubject;
        private java.lang.String smsMessage;

        /**
         * Sets the value of {@link UserVerificationConfig#getEmailBody}
         * @param emailBody The email body template for the verification email sent to the user upon sign up.
         *                  See https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-templates.html to
         *                  learn more about message templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder emailBody(java.lang.String emailBody) {
            this.emailBody = emailBody;
            return this;
        }

        /**
         * Sets the value of {@link UserVerificationConfig#getEmailStyle}
         * @param emailStyle Emails can be verified either using a code or a link.
         *                   Learn more at https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-email-verification-message-customization.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder emailStyle(software.amazon.awscdk.services.cognito.VerificationEmailStyle emailStyle) {
            this.emailStyle = emailStyle;
            return this;
        }

        /**
         * Sets the value of {@link UserVerificationConfig#getEmailSubject}
         * @param emailSubject The email subject template for the verification email sent to the user upon sign up.
         *                     See https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-templates.html to
         *                     learn more about message templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder emailSubject(java.lang.String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        /**
         * Sets the value of {@link UserVerificationConfig#getSmsMessage}
         * @param smsMessage The message template for the verification SMS sent to the user upon sign up.
         *                   See https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-templates.html to
         *                   learn more about message templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder smsMessage(java.lang.String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserVerificationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserVerificationConfig build() {
            return new Jsii$Proxy(emailBody, emailStyle, emailSubject, smsMessage);
        }
    }

    /**
     * An implementation for {@link UserVerificationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserVerificationConfig {
        private final java.lang.String emailBody;
        private final software.amazon.awscdk.services.cognito.VerificationEmailStyle emailStyle;
        private final java.lang.String emailSubject;
        private final java.lang.String smsMessage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.emailBody = this.jsiiGet("emailBody", java.lang.String.class);
            this.emailStyle = this.jsiiGet("emailStyle", software.amazon.awscdk.services.cognito.VerificationEmailStyle.class);
            this.emailSubject = this.jsiiGet("emailSubject", java.lang.String.class);
            this.smsMessage = this.jsiiGet("smsMessage", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String emailBody, final software.amazon.awscdk.services.cognito.VerificationEmailStyle emailStyle, final java.lang.String emailSubject, final java.lang.String smsMessage) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.emailBody = emailBody;
            this.emailStyle = emailStyle;
            this.emailSubject = emailSubject;
            this.smsMessage = smsMessage;
        }

        @Override
        public java.lang.String getEmailBody() {
            return this.emailBody;
        }

        @Override
        public software.amazon.awscdk.services.cognito.VerificationEmailStyle getEmailStyle() {
            return this.emailStyle;
        }

        @Override
        public java.lang.String getEmailSubject() {
            return this.emailSubject;
        }

        @Override
        public java.lang.String getSmsMessage() {
            return this.smsMessage;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEmailBody() != null) {
                data.set("emailBody", om.valueToTree(this.getEmailBody()));
            }
            if (this.getEmailStyle() != null) {
                data.set("emailStyle", om.valueToTree(this.getEmailStyle()));
            }
            if (this.getEmailSubject() != null) {
                data.set("emailSubject", om.valueToTree(this.getEmailSubject()));
            }
            if (this.getSmsMessage() != null) {
                data.set("smsMessage", om.valueToTree(this.getSmsMessage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.UserVerificationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserVerificationConfig.Jsii$Proxy that = (UserVerificationConfig.Jsii$Proxy) o;

            if (this.emailBody != null ? !this.emailBody.equals(that.emailBody) : that.emailBody != null) return false;
            if (this.emailStyle != null ? !this.emailStyle.equals(that.emailStyle) : that.emailStyle != null) return false;
            if (this.emailSubject != null ? !this.emailSubject.equals(that.emailSubject) : that.emailSubject != null) return false;
            return this.smsMessage != null ? this.smsMessage.equals(that.smsMessage) : that.smsMessage == null;
        }

        @Override
        public int hashCode() {
            int result = this.emailBody != null ? this.emailBody.hashCode() : 0;
            result = 31 * result + (this.emailStyle != null ? this.emailStyle.hashCode() : 0);
            result = 31 * result + (this.emailSubject != null ? this.emailSubject.hashCode() : 0);
            result = 31 * result + (this.smsMessage != null ? this.smsMessage.hashCode() : 0);
            return result;
        }
    }
}
